/*--------------------------------------------------------------------------------*
 * File Name: FunctionOrganizerEx.h	 											*
 * Creation: Danice	 															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 12/27/04 v8.0179 CREATATION												*
 * DG 12/15/04 v8.0173 NUMERICFUNCTION_EX_CLASS									*
 * DG 12/27/04 QA70-7265 v8.0179 SYS_FDF_ALLOW_EDITING_SOME_SECTION				*
 * DG 12/31/04 v8.0180 NEW_MECHANISM_FOR_FUNCTION_LOAD							*
 * Iris 01/18/05 CENTRALIZE_FUNCTION_NAME_CODES									*
 * Iris 01/18/05 CLEANUP_CONSTRUCT_FUNC_GUITREE									*
 * DG 2/4/05 REMOVE_CONST_VARIABLE_FROM_GLOBAL_HEADER							*
 * DG 2/5/05 REMOVE_SHARE_CHECK_BOX												*
 * DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME								*
 * DSC 2/7/05 v8.0190 MOVED_CONSTANTS_TO_FUNC_ORG_H								*
 * DG 2/17/05 CENTRALIZE_XFO_AND_NFO											*
 * Frank 1/3/05 CHECK_SIMULATE_NODE_EXIST										*
 * DG 3/30/05 v8.0212 CLEAN_DUPLICATE_MORE										*
 * DG 4/15/05 v8.0217 VC_FUNCTION_SUPPORT										*
 * Jasmine 10/10/05 QA70-8114 v8.0315 ADD_UPPER_LOWER_BOUNDS					*
 * Jasmine 10/11/05 QA70-8114 v8.0315 ADD_INIT_AND_AFTER_FITTING_SCRIPTS		*
 * Jasmine 11/15/05 QA70-8307 v8.0335 ADD_PARAMETERS_SETTINGS					*
 * Jasmine 03/21/06 QA70-8114 v8.0376 ADD_FUNC_FORM								*
 * Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE 								*
 * Jasmine 11/15/06 INITIALIZATION_SCRIPT_TO_SCRIPT_BEFORE_FITTING				*
 * Jasmine 11/24/06 MSG_FOR_REPEATED_VAR_NAME									*
 * Jasmine 11/24/06 MOVE_FUNC_FORM_AND_FUNC_UP									*
 *	CPY 2/19/2007 FO_NEW_FUNC_PARAM_NAMES_LEADING_SPACE_FAILED					*
 * Jasmine 03/01/07 ADD_FO_HELP_TAB												*
 * Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS					*
 * Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX							*
 * Jasmine 03/24/07 REMOVE_SCRIPT_BEFORE_AFTER_FITTING							*
 * TD 4-2-07 QA80-9531 EDITORS_HAVE_NEW_READONLY_STATE							*
 * Cheney 2007-5-9 CLEAN_UP_CODE_FOR_NUMFUNC_LOAD								*
 * Jasmine 05/11/07 ADD_DERIVATIVES_CHECKBOX									*
 * Jasmine 05/15/07 USE_DATA_ID_REPLACE_ROW_NUM									*
 * Jasmine 05/18/07 MODIFICATION_FOR_FDFT_CONVERT_BOOL_TO_01					*
 * Jasmine 06/05/07 QA80-9853 NEED_CHECK_STR_COMPILE_PARAM_SCRIPT_FOR_75_FDF	*
 * Max 6/6/07 TURN_ON_CONSTRAINTS												*
 * Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT				*
 * Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION						*
 * Jasmine 07/10/07 SET_ID_TO_NEW_DERIVED_PARAMETERS_TREENODE					*
 * Jasmine 07/23/07 MAKE_VALID_C_NAME_IS_STRICTER								*
 * Jasmine 07/23/07 NO_POPUP_MESSAGE_IF_NO_NEED 								*
 * Folger 09/06/07 DISABLE_ALL_FOR_GROUP_FIT_FUNCTION							*
 * Folger QA70-10890 01/02/08 ADD_SCRIPT_AFTER_FITTING							*
 * Jasmine 5/28/2008 QA80-11474 TRUE_IF_PARAM_INIT_COMPILE_NODE_MISSING_AND_DISABLE_FOR_BUILT_IN
 * Jasmine 07/28/08 MODIFY_DEFINE_PEAK_FUNC_ERRMSG_BY_MAX_REQUEST				*
 * Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC				*
 * Kyle 11/05/2008 QA80-12509-P1 ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO	*
 *	Sophy 11/6/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Kyle 03/26/2009 QA80-13291-P4 NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION		*
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Kyle 09/03/2009 QA80-14077 ADD_NODE_ID_FOR_NEW_ADDED_UNIT_SINCE_VC_WILL_GET_VALUES_BY_ID
 *	Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI*
 *	Sophy 11/9/2009 INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI	*
 *	Jasmine 11/24/09 QA80-14726 80_HAS_MISSED_CONSTANTS_SECTION					*
 *	Folger 11/28/09 QA81-14726-P2 80_HAS_MISSED_CONSTANTS_SECTION				*
 *	Jasmine 07/22/10 ORG-598-P3 NOT_RETURN_FOR_MINOR_ERROR						*
 *	Jasmine 07/27/10 ORG-486-P4 COMPATIBLE_WITH_OLD_PEAK_FIT_FDF				*
 *------------------------------------------------------------------------------*/


#ifndef _NFO_EX_H_
#define _NFO_EX_H_

#include <GetNBox.h>
//#include <OCTreeUtils2.h> //---------- CPY 7/19/06 FIX_BAD_DEFAULT_STR
#include <OCTreeUtils.h>	//Hong 7/26/06 REMOVE_TEMP_HEADER

///Danice SYS_FDF_ALLOW_EDITING_SOME_SECTION
#define NLF_ALLOW_SYS_FDF_CHANGE_BY_USER 		1
///end SYS_FDF_ALLOW_EDITING_SOME_SECTION

#define STR_TEMP_XML_FILE					"_tempChangedFDFs.xml"	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION

///DSC 2/7/05 v8.0190 MOVED_CONSTANTS_TO_FUNC_ORG_H   Moved to "FunctionGroup.h"
/*
#define STR_NODE_FUNCTION					"Function"
#define STR_NODE_CATEGORY					"Category"
#define STR_NEW_FUNCTION_PREFIX				"NewFunction"
#define STR_NEW_CATEGORY_PREFIX				"NewCategory"
#define STR_DUPLICATE_PREFIX				"CopyOf"

//Function structure in GUI
#define STR_FUNC_NAME						"Name"
#define STR_FUNC_FILE_NAME					"File Name(.fdf)"
#define STR_FUNC_DESCRIPTION				"Brief Description"
#define STR_FUNC_TYPE						"Type"
#define STR_FUNC_INDEPENDENT_VARS			"Independent Vars"
#define STR_FUNC_DEPENDENT_VARS				"Dependent Vars"
#define STR_FUNC_PARAMETER_NAMES			"Parameter Names"
#define STR_FUNC_FUNCTION					"Function"
#define STR_FUNC_CONSTRAINTS				"Constraints"
#define STR_FUNC_EQUATION_PREV				"Equation Prev"
#define STR_FUNC_CURVE_PREV					"Curve Prev"
#define STR_FUNC_SHARE_INFO					"Share Function?"
/// YuI 7/22/04 v7.5102 QA70-6404 NEW_FUNCTION_MANAGER
#define	STR_FUNC_PARA_INIT					"Parameters Initialization"
///end NEW_FUNCTION_MANAGER

///DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME
#define STR_FUNC_FORM					"Function Form"
#define STR_FUNC_TYPE					"Function Type"
#define STR_FUNC_GENERAL_INFO				"General Info"
#define STR_FUNC_FIT_PARAM					"Fitting Parameters"
#define STR_FUNC_FORMULA					"Formula"
#define STR_FUNC_CONSTRAINTS				"Constraints"
#define STR_FUNC_PARAM_INIT					"Parameters Initialization"

///end CONVERT_STRING_TO_TAG_NAME
*/
///end MOVED_CONSTANTS_TO_FUNC_ORG_H



///---DG 2/4/05 REMOVE_CONST_VARIABLE_FROM_GLOBAL_HEADER
/*
const vector<string> vsReadOnlyFuncType={"Built-in", "External DLL"};
const vector<string> vsFuncType={"Y-Script", "Expression", "Equations", "Origin C"};
enum {	FUNCTION_FORM_Y_SCRIPT, 
		FUNCTION_FORM_EXPRESSION,
		FUNCTION_FORM_EQUATIONS,
		FUNCTION_FORM_ORIGINC
};
/// YuI 7/23/04 v7.5103 QA70-6582 GETN_MULTILINE_TEXT_IMPLEMENTATION
#define	ORIGINC_FUNCTION_TYPE_IN_COMBO	vsFuncType[FUNCTION_FORM_ORIGINC]
/// end GETN_MULTILINE_TEXT_IMPLEMENTATION
*/

///DSC 2/7/05 v8.0190 MOVED_CONSTANTS_TO_FUNC_ORG_H   Moved to "FunctionGroup.h"
/*
#define STR_FUNCTION_TYPE_Y_SCRIPT			"Y-Script"
#define STR_FUNCTION_TYPE_EXPRESSION		"Expression"
#define STR_FUNCTION_TYPE_EQUATIONS			"Equations"
#define STR_FUNCTION_TYPE_ORIGINC			"Origin C"
#define IDS_OPTION_TYPE_BUILT_IN 			"Built-in"
#define IDS_OPTION_TYPE_DLL     			"External DLL"

#define	ORIGINC_FUNCTION_TYPE_IN_COMBO		STR_FUNCTION_TYPE_ORIGINC
*/
///end MOVED_CONSTANTS_TO_FUNC_ORG_H   Moved to "FunctionGroup.h"
///Jasmine 03/21/06 ADD_FUNC_FORM
string get_fit_function_form_list()//get_fit_function_type_list()
{
	string strList;
	//strList.Format("%s|%s|%s|%s", STR_FUNCTION_TYPE_Y_SCRIPT, STR_FUNCTION_TYPE_EXPRESSION, STR_FUNCTION_TYPE_EQUATIONS, STR_FUNCTION_TYPE_ORIGINC);
	strList.Format("%s|%s|%s|%s", STR_FUNCTION_FORM_Y_SCRIPT, STR_FUNCTION_FORM_EXPRESSION, STR_FUNCTION_FORM_EQUATIONS, STR_FUNCTION_FORM_ORIGIN_C);
///End ADD_FUNC_FORM
	return strList;
}
///---end REMOVE_CONST_VARIABLE_FROM_GLOBAL_HEADER

///DG 5/12/05 REWRITE_SIMULATE : move to NumFunctionOrganizer.h
/*
#define STR_SIMULATE_NODE				"SimulateSetting"
#define STR_CURVE_NODE					"Curve"
*/
///end REWRITE_SIMULATE

//#define MAX_ROW_HEIGTH_SETTING					"3-300"
//----- CPY TD 5/3/07 QA70-9714 FO_CHANGED_TO_USE_FULL_WIDTH_FOR_MULTILINE_EDIT
//#define MAX_ROW_HEIGTH_SETTING					"3-10" // set a better max row height for default expand/// Hong 02/12/07 v8.0560 ADD_EXPSHR_BUTTON_ON_MULTI_EDIT
#define MAX_ROW_HEIGTH_SETTING					"3-20"
#define MAX_ROW_HEIGHT_NO_EDITOR				"2-10"
//-----
class NumFunctionOrganizerEx : public NumFunctionOrganizer
{
public :
	NumFunctionOrganizerEx()
	{
		m_vsCopyAttribute.SetSize(0);
		m_vsCopyAttribute.Add(STR_CHANGED_ATTRIB);		//---- save change function name
		m_vsCopyAttribute.Add(STR_OLDFILENAME_ATTRIB);	//---- save function old file name		///DG 2/1/05 : duplicate function, old file name should not be copied
		m_vsCopyAttribute.Add(STR_FILENAME_ATTRIB);		//---- save function current file name( you want to change name)
		m_vsCopyAttribute.Add(STR_LABEL_ATTRIB);		//---- save function current name
		m_vsCopyAttribute.Add(STR_DATAID_ATTRIB);
		m_vsCopyAttribute.Add(STR_DISPLAY_ATTRIB);		//---- category icon		///DG 4/2/05 FOLDER_WITH_DISPLAY_ICON
		m_vsCopyAttribute.Add(STR_FUNCTION_FORM_SHARE_FILE_ATTRIB);	//--- if exist mean this function was get from share folder
	}
	~NumFunctionOrganizerEx() {;}
	
	//virtual
	//int				GetCategoryList(TreeNode &trCategoryList, bool bGetFunctionList = true);	///DG 4/15/05 VC_FUNCTION_SUPPORT
	string			GetFuncFilePath(TreeNode tr, int nPath=USER_FOLDER);	///DG 3/7/08
	
	bool			New(TreeNode &trFunction, string strName="");
	///Cheney 2007-5-9 CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
	//bool			Load(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string strName="");
	bool			Load(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, LPCSTR lpcszFunctionName = NULL, bool bLoadFDF = true);
	///end CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
	bool			Add(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string strName="");
	bool 			Delete(TreeNode &trFunction, bool bRemoveFile = true);
	bool			Duplicate(TreeNode &trFunction, TreeNode trSource, string strName="");
	///Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	bool			Reset(TreeNode &trFunction);
	bool			ResetCategory(TreeNode &trCategory);
	///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	///Sophy 11/6/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	//bool	 		Save(TreeNode &trFunction, LPCSTR lpcszFullpathFilename = NULL);
	bool	 		Save(TreeNode &trFunction, LPCSTR lpcszFullpathFilename = NULL, string* pstrErr = NULL );
	///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	//bool			SaveToCategory(TreeNode &trFunction, LPCSTR lpcszCategory);
	
	bool			NewCategory(TreeNode &trCategory, string strName="");
	int				LoadCategory(TreeNode &trCategory, vector<int> &vnInvalidFunctionIndex);
	//bool 			DeleteCategory(TreeNode &trCategory); //don't need, use base is ok
	bool			DuplCategory(TreeNode &trCategory, TreeNode trSource, string strName="");
	//bool			SaveCategoryName(TreeNode &trCategory, string strName);
	
	bool			OnAfterValueChange(TreeNode &trRow, TreeNode &trFunction, int nRow, bool *pUndo=NULL, string *pStrError=NULL); ///DG CLEAN_DUPLICATE_MORE
	bool			IsCategory(TreeNode tr);
	
	bool		ConstructFunctionDetail(const TreeNode &trFunction, TreeNode &trFunctionDetail, string* pstrErr = NULL);
	
	//bool		SaveSimulateTree(TreeNode trFunction);	///DG 5/12/05 REWRITE_SIMULATE : move into base class virtual function
	
	bool		CheckFileNameExist(string strFileName, const string strCheckInFolder);
	string 		GetFunctionName(TreeNode& trFunction, bool bPrefixIncluding = false);  ///Iris 01/18/05 CENTRALIZE_FUNCTION_NAME_CODES
	//void 		SetFunctionName(TreeNode& trFunction, string strFunctionName, string *pstrFilePath= NULL);	///DG 2/25/05
	void 		SetFunctionName(TreeNode& trFunction, string strFunctionName, const int *pnPath=NULL);
	
	int			OnShowMenu(TreeNode &trRow, TreeNode &trFunction, int nx, int ny, HWND hWndParent, int nRow, bool bFODlg=true); ///DG 4/1/05 CLEAN_DUPLICATE_MORE
	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	void 		SetChangedFDFTree(TreeNode& trFDFs);
	void 		ClearChangedFDFTree(LPCSTR lpcszFunctionName);
	///End NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	bool 		IsPeakFuncHasOffsetParam(LPCSTR lpcszParams, bool b2DFunc, string& strErrMsg);
	bool 		IsPeakFuncHasAttribute(const TreeNode& trFunction, bool b2DFunc, string& strErrMsg);	//bool 		IsPeakFuncHasMeaning(LPCSTR lpcszMeaning, bool b2DFunc, string& strErrMsg);	///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	///End DEFINE_PEAK_FUNC_IN_FO
	
protected :
	///Sophy 11/9/2009 INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI virtual it
	//void 		ConstructFuncGUITree(const TreeNode& trFuncDetail, TreeNode &trFuncTree);
	//void 		UpdateFunctionByGUITree(const TreeNode &trFuncTree, TreeNode &trFuncDetail);
	virtual void 		ConstructFuncGUITree(const TreeNode& trFuncDetail, TreeNode &trFuncTree);
	virtual	bool 		UpdateFunctionByGUITree(const TreeNode &trFuncTree, TreeNode &trFuncDetail, string* pstrErr = NULL);
	///end INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI
	int			ConvertCategoryDetailToGUITree(const TreeNode &trCategoryDetail, TreeNode &trCateTree, vector<int> &vnInvalidDetailIndex);
private :
	bool		checkGetPeakAttributeFromMeaning(const TreeNode& trFuncDetail, TreeNode& trCopy);	///Jasmine 07/27/10 ORG-486-P4 COMPATIBLE_WITH_OLD_PEAK_FIT_FDF
	bool 		isFuncReadOnly(TreeNode trFunc);
	bool 		isFuncExternalDLL(TreeNode trFunc);///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	int			addSubNodeByList(const string strList, TreeNode &trRoot, char chDelimiter);
	void 		setupMultilineEditNode(TreeNode& trGUI, const TreeNode& trFDF, int nEnable, int nButtonEditID = 0);

	void		recordAttribute(const TreeNode &trSrc, TreeNode &trDest);
	///Jasmine 11/24/06 MSG_FOR_REPEATED_VAR_NAME
	void 		onVariableNameListChange(TreeNode &trVarList, TreeNode &trFunction, string *pStrError=NULL);
	int			correctVarNameList(string &strList, char chDelimiter, string *pStrError=NULL);
	///End MSG_FOR_REPEATED_VAR_NAME
private:
	//TreeNode	m_trAllCategory;
	vector<string> 		m_vsCopyAttribute;
	Tree				m_trChangedFDFs;	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
};

///Sophy 11/9/2009 INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI
class FitFunctionOrganizer : public NumFunctionOrganizerEx
{
protected:
	//virtual
	void 		ConstructFuncGUITree(const TreeNode& trFuncDetail, TreeNode &trFuncTree);
	//virtual
	bool 		UpdateFunctionByGUITree(const TreeNode &trFuncTree, TreeNode &trFuncDetail, string* pstrErr = NULL){return true;}
};
///end INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI
///DG 4/15/05 VC_FUNCTION_SUPPORT
/*
int			NumFunctionOrganizerEx::GetCategoryList(TreeNode &trCategoryList, bool bGetFunctionList) // = true
{
	//m_trAllCategory=trCategoryList;
	return NumFunctionOrganizer::GetCategoryList(trCategoryList, bGetFunctionList);
}
*/
///end VC_FUNCTION_SUPPORT
string		NumFunctionOrganizerEx::GetFuncFilePath(TreeNode tr, int nPath) //=USER_FOLDER
{
	string strPath=GetFunctionFileFullPath(GetFuncFileName(tr), nPath);
	return strPath;
}
//get all function GUI tree in Category
int			NumFunctionOrganizerEx::LoadCategory(TreeNode &trCategory, vector<int> &vnInvalidDetailIndex)
{
	Tree trCateDetail;
	trCateDetail=trCategory.Clone();
	NumFunctionOrganizer::LoadCategory(trCateDetail, vnInvalidDetailIndex);
	
	return ConvertCategoryDetailToGUITree(trCateDetail, trCategory, vnInvalidDetailIndex);
}
bool			NumFunctionOrganizerEx::ConstructFunctionDetail(const TreeNode &trFunction, TreeNode &trFunctionDetail, string* pstrErr/* = NULL*/)
{
	TreeNode trCategory=trFunction.Parent();
	TreeNode trParent=trFunctionDetail.Parent();
	if(trParent)
		recordAttribute(trCategory, trParent);
	recordAttribute(trFunction, trFunctionDetail);
	string strOldVal;
	if(trFunctionDetail.GetAttribute(STR_CHANGED_ATTRIB, strOldVal) && !strOldVal.IsEmpty())
		SetLabel(trFunctionDetail, strOldVal);
	if(trFunctionDetail.GetAttribute(STR_OLDFILENAME_ATTRIB, strOldVal) && !strOldVal.IsEmpty())
		SetFuncFileName(trFunctionDetail,strOldVal );

	if(Load(trFunctionDetail))
	{
		//apply user change to detail
		///Jasmine 07/20/10 ORG-486-S3 NOT_ALLOW_SAVE_INVALID_PEAK_FUNCTION
		//UpdateFunctionByGUITree(trFunction, trFunctionDetail);
		//return true;
		bool bRet = UpdateFunctionByGUITree(trFunction, trFunctionDetail, pstrErr);
		return bRet;
		///End NOT_ALLOW_SAVE_INVALID_PEAK_FUNCTION
	}
	return false;
}
bool		NumFunctionOrganizerEx::New(TreeNode &trFunction, string strName)
{
	Tree tr;
	string strNewFuncName=strName;
	if(strName.IsEmpty())
		strNewFuncName=STR_NEW_FUNCTION_PREFIX;
	NumFunctionOrganizer::New(tr, okutil_separate_composite_name(strName));
	
	ConstructFuncGUITree(tr, trFunction);
	return true;
}

///Cheney 2007-5-9 CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
//bool		NumFunctionOrganizerEx::Load(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string strName) //=""
bool		NumFunctionOrganizerEx::Load(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, LPCSTR lpcszFunctionName, bool bLoadFDF) //=NULL, true
///end CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
{
	Tree tr;
	///Cheney 2007-5-9 CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
	//if(!NumFunctionOrganizer::Load(tr, lpcszFullpathFilename))
	string strName(lpcszFunctionName);
	if(!NumFunctionOrganizer::Load(tr, lpcszFullpathFilename, NULL, bLoadFDF))
	///end CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
		return false;
	
	if(!strName.IsEmpty())
		SetFunctionName(tr, strName);
	ConstructFuncGUITree(tr, trFunction);
	return true;
}
bool		NumFunctionOrganizerEx::Add(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string strName) //=""
{
	Tree tr;
	if(!NumFunctionOrganizer::Add(tr, lpcszFullpathFilename, strName))
		return false;
	
	ConstructFuncGUITree(tr, trFunction);
	return true;
}
bool 			NumFunctionOrganizerEx::Delete(TreeNode &trFunction, bool bRemoveFile)
{
	string strCateName=GetLabel(trFunction.Parent());
	trFunction.SetAttribute(STR_CATEGORY_ATTRIB, strCateName);
	return NumFunctionOrganizer::Delete(trFunction, bRemoveFile);
}
bool		NumFunctionOrganizerEx::Duplicate(TreeNode &trFunction, TreeNode trSource, string strName)
{
	Tree tr;
	TreeNode trDetail=tr.AddNode("Source");
	TreeNode trDupl=tr.AddNode("Dest");
	if(ConstructFunctionDetail(trSource, trDetail))
	{
		ClearChanged(trDetail);	//as function has been markchanged before duplicate
		NumFunctionOrganizer::Duplicate(trDupl, trDetail, strName);
		ConstructFuncGUITree(trDupl, trFunction);
	}
	return true;
}
///Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
bool		NumFunctionOrganizerEx::Reset(TreeNode &trFunction)
{
	string strFuncPath;
	if(trFunction && trFunction.FileNameFDF)
		strFuncPath = trFunction.FileNameFDF.strVal;
	ClearChangedFDFTree(GetFunctionName(trFunction));
	Tree tr;
	if(ConstructFunctionDetail(trFunction, tr))
		NumFunctionOrganizer::Reset(tr);
	trFunction.Reset();
	Load(trFunction, strFuncPath);
	return true;
}
bool		NumFunctionOrganizerEx::ResetCategory(TreeNode &trCategory)
{
	foreach(TreeNode trNode in trCategory.Children)
	{
		if(!IsFunction(trNode))
		{
			ResetCategory(trNode);
		}
		else if(!Reset(trNode))
			return false;
	}
	return true;
}
///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
///Sophy 11/6/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
//bool	 	NumFunctionOrganizerEx::Save(TreeNode &trFunction, LPCSTR lpcszFullpathFilename)// = NULL
bool	 	NumFunctionOrganizerEx::Save(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string* pstrErr )// = NULL, = NULL
///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
{
	if(!CheckChanged(trFunction))
		return true;
	Tree tr;
	TreeNode trCategory=trFunction.Parent();
	string strCategoryName ;
	strCategoryName = GetLabel(trCategory);
	//tr.SetAttribute(STR_CATEGORY_ATTRIB, strCategoryName);	//DG 8/17/05 : set after construct function detail
	if(ConstructFunctionDetail(trFunction, tr, pstrErr))
	{
		tr.SetAttribute(STR_CATEGORY_ATTRIB, strCategoryName);	///DG 8/17/05
		///Sophy 11/6/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		//if(NumFunctionOrganizer::Save(tr, lpcszFullpathFilename))
		if(NumFunctionOrganizer::Save(tr, lpcszFullpathFilename, pstrErr ))
		///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		{
			recordAttribute(tr, trFunction);///Frank : After save function detail, may be attribute STR_FUNCTION_FORM_SHARE_FILE_ATTRIB will change, so need recode to gui tree.
			ClearChanged(trFunction);
			ClearChanged(trCategory);	///Danice : by now, save function will auto save category ///DG 2/23/05 category save once change
			ClearChangedFDFTree(GetFunctionName(trFunction));	///Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
			return true;
		}
	}
	return false;
}
bool		NumFunctionOrganizerEx::NewCategory(TreeNode &trCategory, string strName)
{
	//Tree tr;
	return NumFunctionOrganizer::NewCategory(trCategory, strName);
	///DG 2/24/05 don't new function inside, same as x-function
	/*
	TreeNode trFuncDetail=tr.AddNode(STR_NEW_FUNCTION_PREFIX);
	NumFunctionOrganizer::New(trFuncDetail);
	tree_node_copy_attribute(tr, trCategory, STR_LABEL_ATTRIB);
	TreeNode trNewFunction=trCategory.AddNode("NewFunction");
	ConstructFuncGUITree(trFuncDetail, trNewFunction);
	return true;
	*/
}
bool		NumFunctionOrganizerEx::DuplCategory(TreeNode &trCategory, TreeNode trSource, string strName)
{
	Tree tr;
	TreeNode trCategoryDetail=tr.AddNode("Category");
	TreeNode trDupCategoryDetail=tr.AddNode("DupCategory");
	trCategoryDetail=trSource.Clone();
	
	foreach(TreeNode trNode in trCategoryDetail.Children)
		trNode.Reset(true);
	
	trCategory.Replace(trCategoryDetail, true, true);
	
	vector<int> vnTemp;
	NumFunctionOrganizer::LoadCategory(trCategoryDetail, vnTemp);

	NumFunctionOrganizer::DuplCategory(trDupCategoryDetail, trCategoryDetail, strName);
	
	ConvertCategoryDetailToGUITree(trDupCategoryDetail, trCategory, vnTemp);
	//Change all function status to User folder
	foreach(TreeNode trFunction in trCategory.Children)
	{
		SetLabel(trFunction, GetFunctionNameStr(GetFunctionName(trFunction), USER_FOLDER));
	}
	return true;
}
bool		NumFunctionOrganizerEx::OnAfterValueChange(TreeNode &trRow, TreeNode &trFunction, int nRow, bool *pUndo, string *pStrError) ///DG CLEAN_DUPLICATE_MORE
{
	if(!trRow)
		return error_report("No-exist node value change");
	
	bool bUndo=false;
	switch(nRow)
	{
	///Jasmine 05/15/07 USE_DATA_ID_REPLACE_ROW_NUM 
	case FUNC_TREE_FUNC_NAME_ID://NAME:
		string strNewName=trRow.strVal;
		if(!UpdateFuncName(trRow, trFunction, pStrError))
			bUndo=true;
		break;
	case FUNC_TREE_FILE_NAME_ID://FILENAME:
		if(!UpdateFileName(trRow, trFunction, pStrError))
			bUndo=true;
		break;
	case FUNC_TREE_PARAMETER_NAMES_ID://PARAMETER_NAMES:
	case FUNC_TREE_INDEPENDENT_VARS_ID://INDEPENDENT_VARS:
	case FUNC_TREE_DEPENDENT_VARS_ID://DEPENDENT_VARS:
		onVariableNameListChange(trRow, trFunction, pStrError);///Jasmine 11/24/06 MSG_FOR_REPEATED_VAR_NAME
		if( FUNC_TREE_PARAMETER_NAMES_ID == nRow && pStrError && pStrError->IsEmpty() )
		{
			TreeNode trPeakFunc = GetNodeCheckAdd(trFunction, STR_PEAK_FUNC_CHECK_E, false);
			if(!trPeakFunc || false == trPeakFunc.nVal)
				break;
		
			bool b2DFunc = _is_2d_func(trFunction);
			
			string strErrMsg;
			IsPeakFuncHasOffsetParam(trRow.strVal, b2DFunc, strErrMsg);
		}
		break;
	case FUNC_TREE_FUNC_TYPE_ID://TYPE:///--Frank	6/18/04 v8.0892 ADD_FUNCTION_FORM_VALUE_REPLACE_FUNCTION_TYPE
	///Jasmine 10/11/05 QA70-8114 v8.0315 ADD_INIT_AND_AFTER_FITTING_SCRIPTS
	///Jasmine 11/15/05 QA70-8307 v8.0335 ADD_PARAMETERS_SETTINGS
	/*
	case PARAMETER_UPPER_BOUNDS:
	case PARAMETER_LOWER_BOUNDS:
	*/
	
	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO 
	case FUNC_TREE_IS_PEAK_FUNC_ID:
	case FUNC_TREE_PARAMETERS_SETTINGS_ID://PARAMETERS_SETTINGS:
		if(NULL == pStrError)
		{
			error_report("need error string to pass error");
			break;
		}
		
		TreeNode trPeakFunc = GetNodeCheckAdd(trFunction, STR_PEAK_FUNC_CHECK_E, false);
		if(!trPeakFunc || false == trPeakFunc.nVal)
			break;
		
		bool b2DFunc = _is_2d_func(trFunction);
		
		string strMeaning;
		TreeNode trParamSetting = GetNodeCheckAdd(trFunction, STR_FUNC_PARAMETERS_SETTINGS, false);
		if(trParamSetting)
		{
			string strParamSetting = trParamSetting.strVal;
			vector<string> vs;
			strParamSetting.GetTokens(vs, '\n');
			int nFind = vs.Find(STR_PARAM_SETTING_MEANINGS, 0, false, false);
			if(-1 < nFind)
			{
				strParamSetting = vs[nFind];
				strMeaning = strParamSetting.GetToken(1, '=');
			}
		}
		
		string strErrMsg;
		//if( IsPeakFuncHasMeaning(strMeaning, b2DFunc, strErrMsg) )///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
		if( IsPeakFuncHasAttribute(trFunction, b2DFunc, strErrMsg) )
		{
			TreeNode trParams = GetNodeCheckAdd(trFunction, STR_FUNC_PARAMETER_NAMES, false);
			IsPeakFuncHasOffsetParam(trParams.strVal, b2DFunc, strErrMsg);
		}
		
		break;
	///End DEFINE_PEAK_FUNC_IN_FO
	
	///End ADD_PARAMETERS_SETTINGS
#ifdef ALLOW_SCRIPT_BEFORE_AFTER_FITTING
	case FUNC_TREE_INIT_SCRIPT_ID://INIT_SCRIPTS:
	case FUNC_TREE_SCRIPT_AFTER_FITTING_ID://AFTER_FITTING_SCRIPTS:
#endif //ALLOW_SCRIPT_BEFORE_AFTER_FITTING 
	///End ADD_INIT_AND_AFTER_FITTING_SCRIPTS
	case FUNC_TREE_PARA_INIT_ID://PARA_INIT:/// YuI 7/22/04 v7.5102 QA70-6404 NEW_FUNCTION_MANAGER
	case FUNC_TREE_FUNC_FORM_ID://FORM:	///Jasmine 03/21/06 ADD_FUNC_FORM
	case FUNC_TREE_FUNCTION_ID://FUNCTION:
	///End USE_DATA_ID_REPLACE_ROW_NUM
		break;
	default :
		break;
	}
	if(NULL != pUndo)
		*pUndo = bUndo;
	return true;
}
static bool _is_2d_func(const TreeNode& trFunction)
{
	bool b2DFunc = false;
	TreeNode trIndepVar = trFunction.GetNode( cvt_str_to_tag_name(STR_FUNC_INDEPENDENT_VARS) );
	if(trIndepVar)
	{
		string strIndepVar = trIndepVar.strVal;
		b2DFunc = 1 < strIndepVar.GetNumTokens(PARAM_SEPERATE_CHAR);
	}
	
	return b2DFunc;
}
bool		NumFunctionOrganizerEx::IsCategory(TreeNode tr)
{
	if(IsFunction(tr))
		return false;
	int nn=tr.DataID;
	return nn<0;	//top Categorys can not contain functions
}
///DG 5/12/05 REWRITE_SIMULATE : move into base class virtual function
/*
bool		NumFunctionOrganizerEx::SaveSimulateTree(TreeNode trFunction)
{
	Tree tr;
	//Info for FDF file
	tree_node_copy_attribute(trFunction, tr, STR_FILENAME_ATTRIB);
	tree_node_copy_attribute(trFunction, tr, STR_FUNCTION_FORM_SHARE_FILE_ATTRIB);
	Load(tr);
	
	TreeNode trSimulate=trFunction.GetNode(STR_SIMULATE_NODE, false);
	TreeNode trCurve=trFunction.GetNode(STR_CURVE_NODE, false);
	///Frank 1/3/05 CHECK_SIMULATE_NODE_EXIST
	if(trSimulate)
		//tr.AddNode(trSimulate);
	{
		TreeNode trFDFSimulate = GetNodeCheckAdd(tr,STR_SIMULATE_NODE, true );
		trFDFSimulate.Replace(trSimulate); 	
	}
	if(trCurve)
		//tr.AddNode(trCurve);
	{
		TreeNode trFDFCurve = GetNodeCheckAdd(tr,STR_CURVE_NODE, true );
		trFDFCurve.Replace(trCurve);
	}
	///End CHECK_SIMULATE_NODE_EXIST
	
	return NumFunctionOrganizer::SaveToFile(tr);
}
*/
///end REWRITE_SIMULATE
bool		NumFunctionOrganizerEx::CheckFileNameExist(string strFileName, const string strCheckInFolder)
{
	//Fit function diff folder can not have same file(input by User) because it's loading mechanism
	//So, check file name will check all folder
	return NumFunctionOrganizer::CheckGetFunctionFilename(strFileName, false);
}
///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT	
void 		NumFunctionOrganizerEx::SetChangedFDFTree(TreeNode& trFDFs)
{
	;//doing...
}
void 		NumFunctionOrganizerEx::ClearChangedFDFTree(LPCSTR lpcszFunctionName)
{
	if(m_trChangedFDFs && m_trChangedFDFs.GetNodeCount())
	{
		TreeNode trFDF = m_trChangedFDFs.GetNode(lpcszFunctionName);
		if(trFDF)
			trFDF.Remove();
		string strFile = okutil_get_origin_path(USER_FOLDER, STR_FDF_FILE_FOLDER) + STR_TEMP_XML_FILE;
		m_trChangedFDFs.Save(strFile);
	}
}			
///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT

///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
static int _find_meaning(LPCSTR lpcstrMeaning, const vector<string>& vsPossibleName)
{	
	int 	nIndex = -1;	
	string 	strMeaning(lpcstrMeaning);
	
	vector<string> vsMeaning;
	if( 0 >= strMeaning.GetTokens(vsMeaning, PARAM_SEPERATE_CHAR) )
		return nIndex;
	
	for(int ii = 0; ii < vsPossibleName.GetSize(); ii++)
	{
		int nFind = vsMeaning.Find( vsPossibleName[ii] );
		if(0 <= nFind)
		{
			nIndex = nFind;
			break;
		}
	}
	
	return nIndex;
}
bool NumFunctionOrganizerEx::IsPeakFuncHasOffsetParam(LPCSTR lpcszParams, bool b2DFunc, string& strErrMsg)
{
	strErrMsg.Empty();
	
	if( 0 != peak_fit_get_offset_param(lpcszParams, b2DFunc) )
	{
		_dump_peak_func_err(strErrMsg);		
		return false;
	}
	
	return true;
}
///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
//bool NumFunctionOrganizerEx::IsPeakFuncHasMeaning(LPCSTR lpcszMeaning, bool b2DFunc, string& strErrMsg)
bool NumFunctionOrganizerEx::IsPeakFuncHasAttribute(const TreeNode& trFunction, bool b2DFunc, string& strErrMsg)
///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
{	
	bool bRet = true;
	strErrMsg.Empty();
	
	if( bRet && -1 == peak_fit_get_center_param(trFunction, true) )
		bRet = false;
	
	if( bRet && -1 == peak_fit_get_width_param(trFunction, true) )
		bRet = false;
	
	if(b2DFunc)
	{
		if( bRet && -1 == peak_fit_get_center_param(trFunction, false) )
			bRet = false;
		
		if( bRet && -1 == peak_fit_get_width_param(trFunction, false) )
			bRet = false;
	}
		
	if( bRet && -1 == peak_fit_get_height_param(trFunction) )
		bRet = false;
	
	if(!bRet)
		_dump_peak_func_err(strErrMsg);
	
	return strErrMsg.IsEmpty();
}
static void _dump_peak_func_err(string& strErrMsg)
{
	ocu_load_err_msg_str(FO_PEAK_FUNC_MSG, &strErrMsg);		
	OptionalMessage("FODefinePeakFunc", MB_OK, strErrMsg + "\r\n\r\n"+ STR_MSG_FO_HOW_TO_SET_PEAK_ATTRIB);	///Jasmine 07/14/10 ORG-540-P3
}
///End DEFINE_PEAK_FUNC_IN_FO

///Jasmine 10/19/07 QA70-10563 LOCALIZATION_OF_LABEL
/// Hong 11/06/07 v8.0741 MORE_LOCALIZATION
#define GETN_CHECK_L(_NODE_LABEL, _DEFAULT_VAL)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_LABEL), TRGP_CHECK);TREE_ADD_LABEL(GetLocalized(_NODE_LABEL));	///Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
#define GETN_STR_L(_NODE_LABEL, _DEFAULT_VAL)	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_LABEL), TRGP_STR);TREE_ADD_LABEL(GetLocalized(_NODE_LABEL));
#define GETN_STRLIST_L(_NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_LABEL), TRGP_STR);TREE_ADD_LABEL(GetLocalized(_NODE_LABEL)); _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);

///DSC 2/9/2005 v8.0191 REMOVE_HARDCODED_TAG_NAMES
#define GETN_MULTILINE_TEXT_L(_NODE_LABEL, _DEFAULT_VAL)  				_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_LABEL), TRGP_MULTILINE_TEXT);TREE_ADD_LABEL(GetLocalized(_NODE_LABEL));
///End LOCALIZATION_OF_LABEL
/// end MORE_LOCALIZATION
/// TD 4-2-07 QA80-9531 EDITORS_HAVE_NEW_READONLY_STATE 
//#define DISABLE_CASE		((bExternalDLL || bAccessable) ? ENABLE : ENABLE_READONLY_SCROLL)		///Jasmine 06/02/08 BOOL_NAME_MISLEADING_IN_ConstructFuncGUITree
#define _CVT_ENABLE(_BENABLE)	  (_BENABLE)? ENABLE : ENABLE_READONLY_SCROLL
/// end EDITORS_HAVE_NEW_READONLY_STATE 

//if trFuncDetail is invalid will general a empty funtion tree
void 		NumFunctionOrganizerEx::ConstructFuncGUITree(const TreeNode& trFuncDetail, TreeNode &trFuncTree)
{
	if(!trFuncDetail)
		return;
	
	recordAttribute(trFuncDetail, trFuncTree);
	
	string strFuncName = NLFunctionList::GetFunctionName(trFuncDetail);
	string strFileName = NLFunctionList::GetFuncFileName(trFuncDetail, true);	///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE, show full path 
	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT	
	if(m_trChangedFDFs && !m_trChangedFDFs.GetNodeCount())
	{
		string strFile = okutil_get_origin_path(USER_FOLDER, STR_FDF_FILE_FOLDER) + STR_TEMP_XML_FILE;
		if(strFile.IsFile())
			m_trChangedFDFs.Load(strFile);
	}
	if(m_trChangedFDFs && m_trChangedFDFs.GetNodeCount())
	{
		TreeNode trChangedFDF = m_trChangedFDFs.GetNode(strFuncName);
		if(trChangedFDF)
			trFuncDetail.Replace(trChangedFDF);
	}
	///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	TreeNode 	trNode;
	string 		strTemp;
	///Danice SYS_FDF_ALLOW_EDITING_SOME_SECTION
	//bool bShared, bAccessable=(!isFuncReadOnly(trFuncDetail) && IsCurrentUserShared(trFuncDetail, bShared));
	
	//------ Folger 09/06/07 DISABLE_ALL_FOR_GROUP_FIT_FUNCTION
	bool bIsSharedFunction;
	bool bOtherUserFunction = !IsCurrentUserShared(trFuncTree, bIsSharedFunction);///Jasmine 06/02/08 BOOL_NAME_MISLEADING_IN_ConstructFuncGUITree, I found bOtherUserFunction always false...
	bool bSysFunction 		= IsSysFunc(trFuncDetail);
	bool bExternalDLL 		= isFuncExternalDLL(trFuncDetail);///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	
	///Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	//bool bAccessable		= !(bSysFunction || bIsSharedFunction || bExternalDLL);
	bool bAccessable		= !(bSysFunction || bIsSharedFunction);
	///End ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	
	//------ End DISABLE_ALL_FOR_GROUP_FIT_FUNCTION	
	bool bSysFuncSectionAllowChange=!((bSysFunction && !NLF_ALLOW_SYS_FDF_CHANGE_BY_USER) || bOtherUserFunction);
	///end SYS_FDF_ALLOW_EDITING_SOME_SECTION
	
	
	GETN_USE(trFuncTree);
	GETN_OPTION_GRIDLINE(flexGridFlatVert)
	///Jasmine 03/01/07 ADD_FO_HELP_TAB
	GETN_STR_L( STR_FUNC_NAME,  strFuncName) GETN_ID(FUNC_TREE_FUNC_NAME_ID) GETN_CURRENT_SUBNODE.Enable= _CVT_ENABLE(bAccessable); //if it is a Built-in or External DLL function, set it as read only.	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	
	/*// SetGeneralInfo(trFuncDetail, true, "FunctionPrev", strFileName);	///Jasmine 06/02/08 this seems no need
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_PREVIEW, strFileName);*/
	
	///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE, show full path  
	//make file name change with function name
	///DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME
	// GETN_STR(FileName, STR_FUNC_FILE_NAME, strFileName)	GETN_CURRENT_NODE.Enable=bAccessable;	///Frank v8.0168b	12/01/04			FIXED_PROBLEM_NEWBASE_CLASS	
	//GETN_STR_L( STR_FUNC_FILE_NAME, strFileName)	GETN_CURRENT_SUBNODE.Enable=bAccessable;
	GETN_STR_L( STR_FUNC_FILE_NAME, strFileName) GETN_ID(FUNC_TREE_FILE_NAME_ID)
	GETN_CURRENT_SUBNODE.Enable = ENABLE_READONLY_SCROLL;
	///end CONVERT_STRING_TO_TAG_NAME
	///End FUNC_AND_FILE_NAME_ONE_TO_ONE
	
	///DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME
	trNode = GetGeneralInfo(trFuncDetail, false, STR_FUNC_DESCRIPTION);
	///end CONVERT_STRING_TO_TAG_NAME	
	strTemp = trNode? trNode.strVal : "";	
	///DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME
	GETN_STR_L(STR_FUNC_DESCRIPTION, strTemp) GETN_ID(FUNC_TREE_DESCRIPTION_ID) GETN_CURRENT_SUBNODE.Enable= _CVT_ENABLE(bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	///end CONVERT_STRING_TO_TAG_NAME
	
	///Kyle 03/26/2009 QA80-13291-P4 NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION
	TreeNode trReferences = GetReferences(trFuncDetail);
	GETN_MULTILINE_TEXT_L(STR_FUNC_REFERENCES, "") GETN_ID(FUNC_TREE_REFERENCES_ID)
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trReferences, true, 0);
	GETN_CURRENT_SUBNODE.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 1);
	///End NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION
	
	///jasmine 03/21/06 ADD_FUNC_FORM
	string strTypeList = bSysFunction? STR_FUNCTION_TYPE_BUILD_IN : STR_FUNCTION_TYPE_USER_DEFINE +"|"+ STR_FUNCTION_TYPE_EXTERN_DLL;	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	trNode = GetGeneralInfo(trFuncDetail, false, STR_FUNC_TYPE);
	strTemp = trNode? trNode.strVal : strTypeList.GetToken(0, '|');
	GETN_STRLIST_L(STR_FUNC_TYPE, strTemp, strTypeList) GETN_ID(FUNC_TREE_FUNC_TYPE_ID) GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	GETN_OPTION_EVENT(OnChangeFunctionType)	///DG : event must put out of class now, this event just for FO, solve this when bug fix
	///End ADD_FUNC_FORM
	
	trNode = GetGeneralInfo(trFuncDetail, false, STR_FUNCTION_SOURCE);
	string strDLLSource = trNode? trNode.strVal : "";
	if( strDLLSource.IsEmpty() )
		strDLLSource = STR_NO_DLL_SOURCE;
	GETN_STR_L( STR_FUNCTION_DLL_SOURCE, strDLLSource)	GETN_ID(FUNC_TREE_FUNC_SOURCE_ID) GETN_CURRENT_SUBNODE.Enable= _CVT_ENABLE( !(bSysFunction || bIsSharedFunction) );	
	GETN_CURRENT_SUBNODE.Show = bExternalDLL;	
	///End ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	
	strTemp=GetSubNodeNameList(trFuncDetail, STR_FUNC_INDEPENDENT_VARS, ',');
	GETN_STR_L(STR_FUNC_INDEPENDENT_VARS, strTemp)	GETN_ID(FUNC_TREE_INDEPENDENT_VARS_ID)
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
		
	strTemp=GetSubNodeNameList(trFuncDetail, STR_FUNC_DEPENDENT_VARS, ',');
	GETN_STR_L(STR_FUNC_DEPENDENT_VARS, strTemp)	GETN_ID(FUNC_TREE_DEPENDENT_VARS_ID)
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	
	trNode = GetFittingPara(trFuncDetail, false, STR_FUNC_NAMES);
	strTemp = trNode? trNode.strVal : "";
	// GETN_STR(FuncParameterNames, STR_FUNC_PARAMETER_NAMES, strTemp) GETN_CURRENT_NODE.Enable=bAccessable;
	GETN_STR_L(STR_FUNC_PARAMETER_NAMES, strTemp) GETN_ID(FUNC_TREE_PARAMETER_NAMES_ID) GETN_CURRENT_SUBNODE.Enable= _CVT_ENABLE(bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	
	///Jasmine 11/15/05 QA70-8307 v8.0335 ADD_PARAMETERS_SETTINGS
	///Jasmine 11/24/06 MOVE_FUNC_FORM_AND_FUNC_UP
	///Jasmine 03/21/06 ADD_FUNC_FORM
	string strFormList = get_fit_function_form_list();
	trNode = GetGeneralInfo(trFuncDetail, false, STR_FUNC_FORM);
	strTemp = trNode? trNode.strVal : "";
	if( strTemp.IsEmpty() )
		strTemp = ORIGINC_FUNCTION_TYPE_IN_COMBO;
	GETN_STRLIST_L(STR_FUNC_FORM, strTemp, strFormList) GETN_ID(FUNC_TREE_FUNC_FORM_ID) GETN_CURRENT_SUBNODE.Enable= _CVT_ENABLE(bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	GETN_CURRENT_SUBNODE.Show = !bExternalDLL;
	GETN_OPTION_EVENT(OnChangeFunctionForm)		///DG : event must put out of class now, this event just for FO, solve this when bug fix
	
	BOOL	bOriginC = ( 0 == strTemp.Compare(ORIGINC_FUNCTION_TYPE_IN_COMBO) );
	///End ADD_FUNC_FORM
	
	///Jasmine 05/11/07 ADD_DERIVATIVES_CHECKBOX
	bool bEnableDerivatives;	
	trNode = GetGeneralInfo(trFuncDetail, false, STR_FUNC_ANALYTICAL_DERIVATIVES);
	if(trNode.IsValid() && (!trNode.strVal.CompareNoCase("on") || !trNode.strVal.CompareNoCase("1")) && bAccessable)	///Jasmine 05/18/07 MODIFICATION_FOR_FDFT_CONVERT_BOOL_TO_01
		bEnableDerivatives = true;
	GETN_CHECK_L(STR_FUNC_ENABLE_DERIVATIVES, bEnableDerivatives)	GETN_ID(FUNC_TREE_ENABLE_DERIVATIVES_ID)
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bAccessable);
	GETN_CURRENT_SUBNODE.Show = bAccessable;	
	///End ADD_DERIVATIVES_CHECKBOX
	
	trNode = GetFormula(trFuncDetail, false, STR_FUNC_SCRIPT);
	GETN_MULTILINE_TEXT_L( STR_FUNC_FUNCTION, "")	GETN_ID(FUNC_TREE_FUNCTION_ID)
	/// YuI 10/04/06 NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
	int nButtonID = bOriginC ? IDC_OPEN_IN_CODE_BUILDER_BUTTON_FIT_FUNCTION : 0;
	/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
	
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bAccessable, nButtonID);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	

	/// YuI 09/07/05 NLSF_CODE_BUILDER_COMMUNICATION_FIX
	trNode = GetFunctionOCHeader(trFuncDetail, false, STR_FUNC_SCRIPT);
	GETN_MULTILINE_TEXT_L(STR_FUNC_OC_FUNC_HEADER, "")	GETN_ID(FUNC_TREE_OC_FUNC_HEADER_ID)
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bAccessable, 0);
	GETN_CURRENT_SUBNODE.Show = false;
	
	trNode = GetParaInitOCHeader(trFuncDetail, false, STR_FUNC_SCRIPT);
	GETN_MULTILINE_TEXT_L(STR_FUNC_OC_PARA_INIT_HEADER, "")	GETN_ID(FUNC_TREE_OC_PARA_INIT_HEADER_ID)
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bAccessable, 0);
	GETN_CURRENT_SUBNODE.Show = false;
	/// end NLSF_CODE_BUILDER_COMMUNICATION_FIX
		
	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	//bool bPeakFunc = false;//IsPeakFunc();
	//trNode = GetControls(trFuncDetail, false, STR_FUNC_PEAK_CENTER);
	//if(trNode)
		//bPeakFunc = true;
	bool bPeakFunc = peak_fit_is_peak_func(trFuncDetail);
	
	///Jasmine 07/27/10 ORG-486-P4 COMPATIBLE_WITH_OLD_PEAK_FIT_FDF
	bool bGetPeakAttributeFromMeaning = false;
	Tree trCopy;
	if(!bPeakFunc)
		bGetPeakAttributeFromMeaning = checkGetPeakAttributeFromMeaning(trFuncDetail, trCopy);
	
	//GETN_CHECK_L(STR_PEAK_FUNC_CHECK_E, bPeakFunc) GETN_ID(FUNC_TREE_IS_PEAK_FUNC_ID)
	GETN_CHECK_L(STR_PEAK_FUNC_CHECK_E, bPeakFunc || bGetPeakAttributeFromMeaning) GETN_ID(FUNC_TREE_IS_PEAK_FUNC_ID)
	///End COMPATIBLE_WITH_OLD_PEAK_FIT_FDF
	
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bAccessable);
	
	//GETN_BEGIN_BRANCH(Controls, STR_FUNC_CONTROLS)
	//GETN_CURRENT_SUBNODE.Show = false;
	//GETN_END_BRANCH(Controls)
	//CheckCopyPeakAttributeNodes(bPeakFunc, trFuncDetail, trFuncTree);
	///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	///End DEFINE_PEAK_FUNC_IN_FO
	
	trNode = GetParaSettings(trFuncDetail);
	Tree trParaSettings;
	foreach(TreeNode cNode in trNode.Children)
	{
		if(cNode.tagName.CompareNoCase(STR_FUNC_NAMES))
			trParaSettings.strVal += cNode.tagName +" = "+ cNode.strVal +"\n";
	}
	GETN_MULTILINE_TEXT_L(STR_FUNC_PARAMETERS_SETTINGS, "")	GETN_ID(FUNC_TREE_PARAMETERS_SETTINGS_ID)
	
	///Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	/// YuI 10/04/06 NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
	//	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trParaSettings, bAccessable, IDC_OPEN_IN_CODE_BUILDER_BUTTON);
	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	//setupMultilineEditNode(GETN_CURRENT_SUBNODE, trParaSettings, (bExternalDLL || bAccessable), IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_SETTINGS);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	//setupMultilineEditNode(GETN_CURRENT_SUBNODE, trParaSettings, bSysFuncSectionAllowChange && !bExternalDLL, IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_SETTINGS);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trParaSettings, bSysFuncSectionAllowChange, IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_SETTINGS);
	///End NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
	///End ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	GETN_CURRENT_SUBNODE.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 1); // default expand /// Hong 02/12/07 v8.0560 ADD_EXPSHR_BUTTON_ON_MULTI_EDIT	
	GETN_OPTION_EVENT(OnModifyParaInit)
	///End ADD_PARAMETERS_SETTINGS
		
	///Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
	///Jasmine 06/05/07 QA80-9853 NEED_CHECK_STR_COMPILE_PARAM_SCRIPT_FOR_75_FDF
	bool bEnableParaInit;// = true;	
	trNode = GetControls(trFuncDetail, false, STR_FUNC_ENABLE_PARAMETERS_INIT);//STR_FUNC_INIT_SCRIPT);
	TreeNode trComplie = GetControls(trFuncDetail, false, STR_COMPILE_PARAM_SCRIPT);
	if(!trNode && !trComplie)
	{
		if(bSysFunction)//built-in
			bEnableParaInit = true;
		else
		{
			string strParaInit;
			TreeNode trParaInit = GetParaInit(trFuncDetail);
			if(trParaInit)
				strParaInit = trParaInit.strVal;
			ocu_skip_C_comments(&strParaInit);
			strParaInit.TrimLeft();
			strParaInit.TrimRight();
			bEnableParaInit = !strParaInit.IsEmpty();
		}
	}
	else
	{
		if(trComplie && !bEnableParaInit && (!trComplie.strVal.CompareNoCase("on") || !trComplie.strVal.CompareNoCase("1")))
			bEnableParaInit = true;
		if(trNode && !bEnableParaInit  && (!trNode.strVal.CompareNoCase("on") || !trNode.strVal.CompareNoCase("1")))
			bEnableParaInit = true;
	}
	///End NEED_CHECK_STR_COMPILE_PARAM_SCRIPT_FOR_75_FDF
	GETN_CHECK_L(STR_FUNC_ENABLE_INIT_SCRIPT, bEnableParaInit)	GETN_ID(FUNC_TREE_ENABLE_PARA_INIT_ID)
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bSysFuncSectionAllowChange);//(bExternalDLL || bAccessable);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	GETN_OPTION_EVENT(OnEnableParaInit)
	///End ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
	
	/// Iris 4/30/2008 QA80-11474 ADD_USE_ORIGINC_CHECKBOX_FOR_PARAM_INIT_SCRIPT
	///Jasmine 5/28/2008 QA80-11474 TRUE_IF_PARAM_INIT_COMPILE_NODE_MISSING_AND_DISABLE_FOR_BUILT_IN
	trNode = GetCompile(trFuncDetail, false, STR_FUNC_PARAM_INIT_COMPILE);//bAddWhenNoExist should be false when read FDF and true when write FDF
	bool bUseOriginC = true;
	if(trNode && false == trNode.nVal)
		bUseOriginC = false;
	GETN_CHECK_L(STR_FUNC_PARAM_SCRIPT_USE_ORIGINC, bUseOriginC)	GETN_ID(FUNC_TREE_PARAM_USE_ORIGINC_ID)
	GETN_OPTION_EVENT(OnEnableParamUseOriginC)
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE(bAccessable);
	///End TRUE_IF_PARAM_INIT_COMPILE_NODE_MISSING_AND_DISABLE_FOR_BUILT_IN
	///END ADD_USE_ORIGINC_CHECKBOX_FOR_PARAM_INIT_SCRIPT
	
	trNode = GetParaInit(trFuncDetail);
	// GETN_MULTILINE_TEXT(ParametersInitialization, STR_FUNC_PARA_INIT, "")
	GETN_MULTILINE_TEXT_L( STR_FUNC_PARA_INIT_GUI, "")	GETN_ID(FUNC_TREE_PARA_INIT_ID)	
	/// YuI 10/04/06 NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
	//	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bAccessable, IDC_OPEN_IN_CODE_BUILDER_BUTTON);
	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	//setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, (bExternalDLL || bAccessable) && bEnableParaInit, IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_INIT);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bSysFuncSectionAllowChange && bEnableParaInit, IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_INIT);	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	///End NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
	GETN_CURRENT_SUBNODE.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 1); // default expand /// Hong 02/12/07 v8.0560 ADD_EXPSHR_BUTTON_ON_MULTI_EDIT
	GETN_OPTION_EVENT(OnModifyParaInit)	
	
#ifdef ALLOW_SCRIPT_BEFORE_AFTER_FITTING	///Jasmine 03/24/07 REMOVE_SCRIPT_BEFORE_AFTER_FITTING, no support
	///Jasmine 10/11/05 QA70-8114 v8.0315 ADD_INIT_AND_AFTER_FITTING_SCRIPTS
	string strTreeNode;
	string strLabel;	
	for(int ii = 0; ii < 2; ii++)
	{
		int ID = ii? FUNC_TREE_SCRIPT_AFTER_FITTING_ID : FUNC_TREE_INIT_SCRIPT_ID;
		strTreeNode = ii? STR_SCRIPT_AFTER_FITTING : STR_INIT_SCRIPT;
		//strLabel = ii? STR_FUNC_SCRIPT_AFTER_FITTING : STR_FUNC_INIT_SCRIPT;///Jasmine 11/15/06 INITIALIZATION_SCRIPT_TO_SCRIPT_BEFORE_FITTING
		strLabel = ii? STR_FUNC_SCRIPT_AFTER_FITTING : STR_FUNC_SCRIPT_BEFORE_FITTING;		
		trNode = GetScripts(trFuncDetail, strTreeNode);
		GETN_MULTILINE_TEXT_L(strLabel, "")	GETN_ID(ID)
		/// YuI 10/04/06 NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
		// no code builder for before/after scripts
		setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bSysFuncSectionAllowChange, 0);
		/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
		GETN_OPTION_EVENT(OnModifyParaInit)
	}
	///End ADD_INIT_AND_AFTER_FITTING_SCRIPTS
#endif //ALLOW_SCRIPT_BEFORE_AFTER_FITTING	///Jasmine 03/24/07 REMOVE_SCRIPT_BEFORE_AFTER_FITTING
	///End MOVE_FUNC_FORM_AND_FUNC_UP
	
	///------ Folger 11/28/09 QA81-14726-P2 80_HAS_MISSED_CONSTANTS_SECTION
	/////Jasmine 11/24/09 QA80-14726 80_HAS_MISSED_CONSTANTS_SECTION
	//trNode = GetNodeCheckAdd(trFuncDetail, STR_FUNC_CONSTANTS, true, "");
	//GETN_MULTILINE_TEXT_L(STR_FUNC_CONSTANTS, "")	GETN_ID(FUNC_TREE_CONSTANTS_ID)
	//Tree trTempConstants;
	//if(trNode)
	//{
		//string str;
		//octree_branch_to_key_value_pairs_str(&trNode, &str);
		//trTempConstants.text.ID = 1; trNode = trTempConstants.text;
		//trNode.strVal = str;
	//}	
	/////End 80_HAS_MISSED_CONSTANTS_SECTION
	trNode = GetConstants(trFuncDetail, true, STR_FUNC_SCRIPT);
	GETN_MULTILINE_TEXT_L(STR_FUNC_CONSTANTS, "")	GETN_ID(FUNC_TREE_CONSTANTS_ID)
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bSysFuncSectionAllowChange, 0);
	///------ End 80_HAS_MISSED_CONSTANTS_SECTION
	
//#ifdef SUPPORT_CONSTRAINTS	/// Max 6/6/07 TURN_ON_CONSTRAINTS
	///Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
	bool bEnableConstraints = true;	
	trNode = GetControls(trFuncDetail, false, STR_FUNC_GENERAL_CONSTRAINTS);
	//if(trNode.IsValid() && !trNode.strVal.CompareNoCase("off"))	///Jasmine 05/18/07 MODIFICATION_FOR_FDFT_CONVERT_BOOL_TO_01
	if(trNode.IsValid() && (!trNode.strVal.CompareNoCase("off") || !trNode.strVal.CompareNoCase("0")))
		bEnableConstraints = false;
	GETN_CHECK_L(STR_FUNC_ENABLE_CONSTRAINTS, bEnableConstraints)	GETN_ID(FUNC_TREE_ENABLE_CONSTRAINTS_ID)
	GETN_CURRENT_SUBNODE.Enable = _CVT_ENABLE( bSysFuncSectionAllowChange );	///Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	GETN_OPTION_EVENT(OnEnableConstraints)
	///End ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
	
	///Danice SYS_FDF_ALLOW_EDITING_SOME_SECTION
	trNode = GetConstraints(trFuncDetail, true, STR_FUNC_SCRIPT);
	// GETN_MULTILINE_TEXT(Constraints, STR_FUNC_CONSTRAINTS, "")
	GETN_MULTILINE_TEXT_L( STR_FUNC_CONSTRAINTS, "")	GETN_ID(FUNC_TREE_CONSTRAINTS_ID)
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bSysFuncSectionAllowChange && bEnableConstraints, 0);///Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	///end SYS_FDF_ALLOW_EDITING_SOME_SECTION
//#endif //SUPPORT_CONSTRAINTS	/// Max 6/6/07 TURN_ON_CONSTRAINTS		
	
	GETN_MULTILINE_TEXT_L( STR_FUNC_DERIVED_PARAMS, "")	GETN_ID(FUNC_TREE_DERIVED_PARAMS_ID)
	///End ADD_FO_HELP_TAB
	//--- CPY 1/7/05 DERIVED_PARAMETERS_READ_SAVE_PROBLEM
	trNode = GetDerivedParams(trFuncDetail);
	Tree trTemp;
	if(trNode)
	{
		string str;
		//tree_branch_to_key_value_pairs_str(trNode, str);
		octree_branch_to_key_value_pairs_str(&trNode, &str);
		trTemp.text.ID = 1; trNode = trTemp.text;
		trNode.strVal = str;
	}
	//---
	//setupMultilineEditNode(GETN_CURRENT_NODE, trNode, true);		///Danice SYS_FDF_ALLOW_EDITING_SOME_SECTION
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bSysFuncSectionAllowChange);	///Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	
	///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
	trNode = GetDeriParaSettings(trFuncDetail);
	Tree trDeriParaSettings;
	if(trNode)
	{
		foreach(TreeNode cNode in trNode.Children)
			trDeriParaSettings.strVal += cNode.tagName +" = "+ cNode.strVal +"\n";
	}
	GETN_MULTILINE_TEXT_L(STR_FUNC_DERIVED_PARAM_SETTINGS, "")	GETN_ID(FUNC_TREE_DERIV_PARAM_SETTINGS_ID)
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trDeriParaSettings, bSysFuncSectionAllowChange);
	GETN_CURRENT_SUBNODE.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 1); // default expand /// Hong 02/12/07 v8.0560 ADD_EXPSHR_BUTTON_ON_MULTI_EDIT	
	///End ADD_UNIT_FOR_PARAMETER_SETTINGS
	
	//GETN_CHECK(UserInfo, STR_FUNC_SHARE_INFO, bIsSharedFunction) GETN_CURRENT_NODE.Enable=bAccessable;		///DG REMOVE_SHARE_CHECK_BOX
	
#ifndef		ALLOW_SCRIPT_BEFORE_AFTER_FITTING /// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
	//------ Folger QA70-10890 01/02/08 ADD_SCRIPT_AFTER_FITTING
	GETN_MULTILINE_TEXT_L(STR_FUNC_SCRIPT_AFTER_FITTING, "")	GETN_ID(FUNC_TREE_SCRIPT_AFTER_FITTING_ID)
	trNode = GetScripts(trFuncDetail, STR_SCRIPT_AFTER_FITTING);
	setupMultilineEditNode(GETN_CURRENT_SUBNODE, trNode, bSysFuncSectionAllowChange, 0);	///Jasmine 07/31/08 QA80-11917 ALLOW_EDIT_FDF_OF_EXTERNAL_DLL_FUNC
	GETN_OPTION_EVENT(OnModifyParaInit)
	//------
#endif		//ALLOW_SCRIPT_BEFORE_AFTER_FITTING /// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
	
	//------ Folger 09/06/07 DISABLE_ALL_FOR_GROUP_FIT_FUNCTION
	if (bIsSharedFunction)
	{
		foreach (TreeNode trnode in trFuncTree.Children)
			trnode.Enable = ENABLE_READONLY_SCROLL;
	}
	//------ End DISABLE_ALL_FOR_GROUP_FIT_FUNCTION
	
	///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	//put this code at the end to separate the hidden nodes from display node.
	//or it will break tree_get_node
	GETN_BEGIN_BRANCH(Controls, STR_FUNC_CONTROLS)
	GETN_CURRENT_SUBNODE.Show = false;
	GETN_END_BRANCH(Controls)
	///Jasmine 07/27/10 ORG-486-P4 COMPATIBLE_WITH_OLD_PEAK_FIT_FDF
	//CheckCopyPeakAttributeNodes(bPeakFunc, trFuncDetail, trFuncTree);
	CheckCopyPeakAttributeNodes(bPeakFunc || bGetPeakAttributeFromMeaning, bGetPeakAttributeFromMeaning? trCopy : trFuncDetail, trFuncTree);
	///End COMPATIBLE_WITH_OLD_PEAK_FIT_FDF
	///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
}

///Jasmine 07/27/10 ORG-486-P4 COMPATIBLE_WITH_OLD_PEAK_FIT_FDF
bool		NumFunctionOrganizerEx::checkGetPeakAttributeFromMeaning(const TreeNode& trFuncDetail, TreeNode& trCopy)
{
	TreeNode trMeaning 	= GetFittingPara(trFuncDetail, false, STR_PARAM_SETTING_MEANINGS);
	if(!trMeaning)
		return false;
	string strMeaning = trMeaning.strVal;
	if(strMeaning.IsEmpty())
		return false;
	
	TreeNode trParams = trFuncDetail.GetNode(cvt_str_to_tag_name(STR_FUNC_FIT_PARAM), false);
	if(!trParams)
		return false;
	
	TreeNode trNames = trParams.GetNode(cvt_str_to_tag_name(STR_FUNC_NAMES), false);
	if(!trNames)
		return false;
	
	///Jasmine 07/28/10 ORG-486-P4 WRONG_DUPLICATE_OFFSET_LEAD_TO_RUNTIME_ERROR
	//necessary condition: 
	//1. Duplicate Offset > 1
	//2. Peak Center
	if(nlf_get_duplicate_offset(trFuncDetail) <= 1)
		return false;
	
	if(peak_fit_get_center_param(trFuncDetail, true) < 0)
		return false;
	///End WRONG_DUPLICATE_OFFSET_LEAD_TO_RUNTIME_ERROR
	
	bool b2DFunc = 1 < nlf_get_independent_variables(trFuncDetail);		
	int offset = 1;//in fdf it has 1 offset
	
	
	//check offset param
	int nOffsetParam = 0;
	if( nOffsetParam != peak_fit_get_offset_param(trNames.strVal, b2DFunc) )
		return false;
	int nParamCount = trNames.strVal.GetNumTokens(',');
	GetControls(trCopy, true, STR_DUPLICATE_NUM).nVal = 0;
	GetControls(trCopy, true, STR_DUPLICATE_OFFSET).nVal = (nOffsetParam + offset) + 1;//start from Offset Parameter's next parameter
	GetControls(trCopy, true, STR_DUPLICATE_UNIT).nVal = nParamCount - (nOffsetParam + offset);//all params except offset param
	
			
	bool bGetX = true;//get x first
	//peak center
	int nCenterParam = peak_fit_get_center_param(trFuncDetail, bGetX);
	if(nCenterParam < 0)
	{
		nCenterParam = peak_fit_get_center_param(strMeaning, bGetX);
		if(nCenterParam < 0)
			return false;		
	}
	GetControls(trCopy, true, STR_FUNC_PEAK_CENTER).nVal = nCenterParam + offset;
	
	
	//peak width
	int nWidthParam = peak_fit_get_width_param(trFuncDetail, bGetX);
	if(nWidthParam < 0)
	{
		nWidthParam = peak_fit_get_width_param(strMeaning, bGetX);
		if(nWidthParam < 0)
			return false;
	}
	GetControls(trCopy, true, STR_FUNC_PEAK_WIDTH).nVal = nWidthParam + offset;

	//get y	
	if(b2DFunc)
	{
		bGetX = false;
		nCenterParam = peak_fit_get_center_param(trFuncDetail, bGetX);
		if(nCenterParam < 0)
		{
			nCenterParam = peak_fit_get_center_param(strMeaning, bGetX);
			if(nCenterParam < 0)
				return false;
		}
		GetControls(trCopy, true, STR_FUNC_PEAK_CENTER2).nVal = nCenterParam + offset;
			
		nWidthParam = peak_fit_get_width_param(trFuncDetail, bGetX);
		if(nWidthParam < 0)
		{
			nWidthParam = peak_fit_get_width_param(strMeaning, bGetX);
			if(nWidthParam < 0)			
				return false;
		}
		GetControls(trCopy, true, STR_FUNC_PEAK_WIDTH2).nVal = nWidthParam + offset;
	}
		
	
	//get peak amplitude
	int nAmplitudeParam = peak_fit_get_height_param(trFuncDetail);
	if(nAmplitudeParam < 0)
	{
		nAmplitudeParam = peak_fit_get_height_param(strMeaning);
		if(nAmplitudeParam < 0)
			return false;
	}
	GetControls(trCopy, true, STR_FUNC_PEAK_AMPLITUDE).nVal = nAmplitudeParam + offset;;
	
	return true;
}
///End COMPATIBLE_WITH_OLD_PEAK_FIT_FDF

bool 		NumFunctionOrganizerEx::UpdateFunctionByGUITree(const TreeNode &trFuncTree, TreeNode &trFuncDetail, string* pstrErr/* = NULL*/)
{
	string strErrMsg = "";	///Jasmine 07/22/10 ORG-598-P3 NOT_RETURN_FOR_MINOR_ERROR
	
	recordAttribute(trFuncTree, trFuncDetail);
	bool bAccessable=trFuncTree.FunctionName.Enable;
	
	string _strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_NAME, false, "").strVal;
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_NAME, _strVal);
	
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_FILE_NAME, false, "").strVal;
	SetFuncFileName(trFuncDetail, _strVal, true);//false);///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE 
	
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_DESCRIPTION, false, "").strVal;
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_DESCRIPTION, _strVal);
	
	///Kyle 03/26/2009 QA80-13291-P4 NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION
	_strVal.Empty();
	TreeNode trReferences = GetNodeCheckAdd(trFuncTree, STR_FUNC_REFERENCES, false, "");
	if(trReferences)
		_strVal = trReferences.strVal;
	SetReferences(trFuncDetail, _strVal);
	///End NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION
	
	///Jasmine 03/21/06 ADD_FUNC_FORM
	/*
	//DG 9/8/05 REUSE_STRVAL : No need to use some many new string variable, just reuse _strVal
	if(bAccessable)
	{
		_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_TYPE, false, "").strVal;
		SetGeneralInfo(trFuncDetail, true, STR_FUNC_FORM, _strVal);
	}
	else
	{
		_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_TYPE, false, "").strVal;
		SetGeneralInfo(trFuncDetail, true, STR_FUNC_TYPE, _strVal);
	}
	*/
	//function type
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_TYPE, false, "").strVal;
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_TYPE, _strVal);
	///End ADD_FUNC_FORM
	
	//independent vars list
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_INDEPENDENT_VARS, false, "").strVal;
	int nNumVariable=addSubNodeByList(_strVal, GetNodeCheckAdd(trFuncDetail, STR_FUNC_INDEPENDENT_VARS, false, ""), ',');
	
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_NUM_IND_VARS, (string)nNumVariable);
	
	
	_strVal="";
	nNumVariable=0;
	//dependent vars list
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_DEPENDENT_VARS, false, "").strVal;
	nNumVariable=addSubNodeByList(_strVal, GetNodeCheckAdd(trFuncDetail, STR_FUNC_DEPENDENT_VARS, false, ""), ',');
	
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_NUM_DEP_VARS, (string)nNumVariable);
	
	//parameter names
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_PARAMETER_NAMES, false, "").strVal;
	GetFittingPara(trFuncDetail, true, STR_FUNC_NAMES).strVal = _strVal;
	string strParamNames = _strVal;

	int nParamCount = _strVal.GetNumTokens(',');
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_NUM_PARAMS, (string)nParamCount);
	
	///Jasmine 11/15/05 QA70-8307 v8.0335 ADD_PARAMETERS_SETTINGS
	/*
	///Jasmine 10/10/05 QA70-8114 v8.0315 ADD_UPPER_LOWER_BOUNDS
	string strTreeNode;
	string strLabel;
	for(int ii = 0; ii < 2; ii++)
	{
		strTreeNode = ii? STR_UPPER_BOUNDS : STR_LOWER_BOUNDS;
		strLabel = ii? STR_FUNC_PARAMETER_UPPER_BOUNDS : STR_FUNC_PARAMETER_LOWER_BOUNDS;
		
		_strVal = GetNodeCheckAdd(trFuncTree, strLabel, false, "").strVal;
		GetFittingPara(trFuncDetail, true, strTreeNode).strVal = _strVal;	
		SetGeneralInfo(trFuncDetail, true, strLabel, (string)_strVal.GetNumTokens(','));
	}
	///End ADD_UPPER_LOWER_BOUNDS
	*/
	string strTemp;
	StringArray strTokens;
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_PARAMETERS_SETTINGS, false, "").strVal;
	TreeNode trNode = GetParaSettings(trFuncDetail);
	_strVal.GetTokens(strTokens, '\n');
	///Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	StringArray strKeys;
	strKeys.Add(STR_FUNC_NAMES);	//separate in gui
	///End REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	for(int ii = 0; ii < strTokens.GetSize(); ii++)
	{
		strTemp = strTokens[ii].GetToken(0,'=');
		strTemp.TrimLeft();
		strTemp.TrimRight();
		///----Jasmine 04/02/07 Add node if not found
		//TreeNode tn = trNode.GetNode(strTemp);
		//if(tn)
		if(!strTemp.IsEmpty())
		{
			strKeys.Add(strTemp);			///Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
			TreeNode tn = GetNodeCheckAdd(trNode, strTemp);
		///----end
			strTemp = strTokens[ii].GetToken(1,'=');
			strTemp.TrimLeft();
			strTemp.TrimRight();
			tn.strVal = strTemp;
			
		}
	}
	///End ADD_PARAMETERS_SETTINGS
	///Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	foreach(TreeNode trSubParaSettings in trNode.Children)
	{
		string strTag = trSubParaSettings.tagName;
		if(strKeys.Find(strTag) < 0)
			trSubParaSettings.strVal = "";
	}
	///End REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	
	///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_DERIVED_PARAM_SETTINGS, false, "").strVal;
	TreeNode trDeriParaSettings = GetDeriParaSettings(trFuncDetail);
	///Kyle 09/03/2009 QA80-14077 ADD_NODE_ID_FOR_NEW_ADDED_UNIT_SINCE_VC_WILL_GET_VALUES_BY_ID, temporary solution
	if(trDeriParaSettings)
		trDeriParaSettings.SetAttribute(STR_ID_ATTRIB, IDS_SECT_DERIV_PARA_SETTINGS);
	///End ADD_NODE_ID_FOR_NEW_ADDED_UNIT_SINCE_VC_WILL_GET_VALUES_BY_ID
	strTokens.SetSize(0);				///Kyle 09/03/2009 strTokens isn't reset if _strVal is empty
	_strVal.GetTokens(strTokens, '\n');
	strKeys.SetSize(0);					///Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	for(ii = 0; ii < strTokens.GetSize(); ii++)
	{
		strTemp = strTokens[ii].GetToken(0,'=');
		strTemp.TrimLeft();
		strTemp.TrimRight();
		if(!strTemp.IsEmpty())
		{
			strKeys.Add(strTemp);		///Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
			TreeNode tn = GetNodeCheckAdd(trDeriParaSettings, strTemp);
			///Kyle 09/03/2009 QA80-14077 ADD_NODE_ID_FOR_NEW_ADDED_UNIT_SINCE_VC_WILL_GET_VALUES_BY_ID, temporary solution
			if(strTemp.CompareNoCase(STR_PARAM_UNIT)==0)
				tn.SetAttribute(STR_ID_ATTRIB, IDS_PARA_UNIT);
			///End ADD_NODE_ID_FOR_NEW_ADDED_UNIT_SINCE_VC_WILL_GET_VALUES_BY_ID
			strTemp = strTokens[ii].GetToken(1,'=');
			strTemp.TrimLeft();
			strTemp.TrimRight();
			tn.strVal = strTemp;
		}
	}
	///End ADD_UNIT_FOR_PARAMETER_SETTINGS
	///Kyle 09/14/2009 REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	foreach(TreeNode trSubDeriParaSettings in trDeriParaSettings.Children)
	{
		string strTag = trSubDeriParaSettings.tagName;
		if(strKeys.Find(strTag) < 0)
			trSubDeriParaSettings.Remove();
	}
	///End REMOVE_SETTINGS_FROM_FDF_TREE_IF_THE_KEY_IS_REMOVED_FROM_GUI
	
	
	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	TreeNode trPeakFunc = GetNodeCheckAdd(trFuncTree, STR_PEAK_FUNC_CHECK_E, false);
	//TreeNode trMeaning 	= trNode.GetNode(STR_PARAM_SETTING_MEANINGS);
	//if(trMeaning && trPeakFunc && true == trPeakFunc.nVal)
	//{
		//bool b2DFunc = 1 < nlf_get_independent_variables(trFuncDetail);
		//
		//int offset = 1;//in fdf it has 1 offset
		//int nOffsetParam = peak_fit_get_offset_param(strParamNames, b2DFunc) + offset;
		//if(0 < nOffsetParam)
		//{
			//ASSERT(1 == nOffsetParam);//offset param must be the first param
			//GetControls(trFuncDetail, true, STR_DUPLICATE_NUM).nVal = 0;
			//GetControls(trFuncDetail, true, STR_DUPLICATE_OFFSET).nVal = nOffsetParam + 1;//next param
			//GetControls(trFuncDetail, true, STR_DUPLICATE_UNIT).nVal = nParamCount - nOffsetParam;//all params except offset param
		//}
		//
		//string strMeaning = trMeaning.strVal;
		//int nCenterParam = peak_fit_get_center_param(strMeaning, true) + offset;
		//if(0 < nCenterParam)
			//GetControls(trFuncDetail, true, STR_FUNC_PEAK_CENTER).nVal = nCenterParam;
		//
		//int nWidthParam = peak_fit_get_width_param(strMeaning, true) + offset;
		//if(0 < nWidthParam)
			//GetControls(trFuncDetail, true, STR_FUNC_PEAK_WIDTH).nVal = nWidthParam;
		//
		//if(b2DFunc)
		//{
			//nCenterParam = peak_fit_get_center_param(strMeaning, false) + offset;
			//if(0 < nCenterParam)
				//GetControls(trFuncDetail, true, STR_FUNC_PEAK_CENTER2).nVal = nCenterParam;
			//
			//nWidthParam = peak_fit_get_width_param(strMeaning, false) + offset;
			//if(0 < nWidthParam)
				//GetControls(trFuncDetail, true, STR_FUNC_PEAK_WIDTH2).nVal = nWidthParam;
		//}
		//
		/////Kyle 11/05/2008 QA80-12509-P1 ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO
		//int nAmplitudeParam = peak_fit_get_height_param(strMeaning) + offset;
		//if(0 < nAmplitudeParam)
			//GetControls(trFuncDetail, true, STR_FUNC_PEAK_AMPLITUDE).nVal = nAmplitudeParam;
		/////End ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO
	//}
	//else
	//{
		/////Kyle 11/05/2008 QA80-12509-P1 ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO
		////vector<string> vs = {STR_FUNC_PEAK_CENTER, STR_FUNC_PEAK_WIDTH, STR_FUNC_PEAK_CENTER2, STR_FUNC_PEAK_WIDTH2};
		//vector<string> vs = {STR_FUNC_PEAK_CENTER, STR_FUNC_PEAK_WIDTH, STR_FUNC_PEAK_CENTER2, STR_FUNC_PEAK_WIDTH2, STR_FUNC_PEAK_AMPLITUDE};
		/////End ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO
		//for(ii = 0; ii < vs.GetSize(); ii++)
		//{
			//trNode = GetControls(trFuncDetail, false, STR_FUNC_PEAK_CENTER);
			//if(trNode)
				//trNode.Remove();
		//}		
	//}
	/////End DEFINE_PEAK_FUNC_IN_FO	
	///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	///Jasmine 07/20/10 ORG-486-S3 NOT_ALLOW_SAVE_INVALID_PEAK_FUNCTION
	bool bPeakFunc = false;
	if(trPeakFunc && true == trPeakFunc.nVal)
	{
		bPeakFunc = peak_fit_is_peak_func_ex(trFuncTree);
		if(!bPeakFunc)
		{
			if(pstrErr)
			{
				ocu_load_err_msg_str(FO_PEAK_FUNC_MSG, &strErrMsg);		
				strErrMsg += "\r\n\r\n"+ STR_MSG_FO_HOW_TO_SET_PEAK_ATTRIB;
				*pstrErr = strErrMsg; 	
			}
			//return false;	///Jasmine 07/22/10 ORG-598-P3 NOT_RETURN_FOR_MINOR_ERROR
		}
	}
	///End NOT_ALLOW_SAVE_INVALID_PEAK_FUNCTION
	CheckCopyPeakAttributeNodes(bPeakFunc, trFuncTree, trFuncDetail);
	///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	
	
	
	/// Iris 4/30/2008 QA80-11474 ADD_USE_ORIGINC_CHECKBOX_FOR_PARAM_INIT_SCRIPT
	trNode = GetNodeCheckAdd(trFuncTree, STR_FUNC_PARAM_SCRIPT_USE_ORIGINC, false);
	if(trNode)
	{
		GetCompile(trFuncDetail, true, STR_FUNC_PARAM_INIT_COMPILE).nVal = trNode.nVal;
	}
		
	///end ADD_USE_ORIGINC_CHECKBOX_FOR_PARAM_INIT_SCRIPT
	
	//parameter init code
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_PARA_INIT_GUI, false, "").strVal;
	GetParaInit(trFuncDetail).strVal = _strVal;
	
#ifdef ALLOW_SCRIPT_BEFORE_AFTER_FITTING	///Jasmine 03/24/07 REMOVE_SCRIPT_BEFORE_AFTER_FITTING
	///Jasmine 10/11/05 QA70-8114 v8.0315 ADD_INIT_AND_AFTER_FITTING_SCRIPTS
	string strTreeNode;
	string strLabel;
	for(ii = 0; ii < 2; ii++)
	{
		strTreeNode = ii? STR_SCRIPT_AFTER_FITTING : STR_INIT_SCRIPT;
		//strLabel = ii? STR_FUNC_SCRIPT_AFTER_FITTING : STR_FUNC_INIT_SCRIPT;///Jasmine 11/15/06 INITIALIZATION_SCRIPT_TO_SCRIPT_BEFORE_FITTING
		strLabel = ii? STR_FUNC_SCRIPT_AFTER_FITTING : STR_FUNC_SCRIPT_BEFORE_FITTING;
		_strVal = GetNodeCheckAdd(trFuncTree, strLabel, false, "").strVal;
		GetScripts(trFuncDetail, strTreeNode).strVal = _strVal;
	}
	///End ADD_INIT_AND_AFTER_FITTING_SCRIPTS
#endif //ALLOW_SCRIPT_BEFORE_AFTER_FITTING	///Jasmine 03/24/07 REMOVE_SCRIPT_BEFORE_AFTER_FITTING

#ifndef		ALLOW_SCRIPT_BEFORE_AFTER_FITTING /// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
	//------ Folger QA70-10890 01/02/08 ADD_SCRIPT_AFTER_FITTING
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_SCRIPT_AFTER_FITTING, false, "").strVal;
	GetScripts(trFuncDetail, STR_SCRIPT_AFTER_FITTING).strVal = _strVal;
	//------
#endif		//ALLOW_SCRIPT_BEFORE_AFTER_FITTING /// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING

	///Jasmine 03/21/06 ADD_FUNC_FORM
	//function form
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_FORM, false, "").strVal;
	SetGeneralInfo(trFuncDetail, true, STR_FUNC_FORM, _strVal);
	/// Hong 05/17/07 QA80-9784 FIX_FUNCTION_FORM_CONFLICT_BETWEEN_75_80
	UpdateCompileByFunctionForm(trFuncDetail);
	/// end FIX_FUNCTION_FORM_CONFLICT_BETWEEN_75_80
	///End ADD_FUNC_FORM
	
	///Jasmine 05/11/07 ADD_DERIVATIVES_CHECKBOX
	bool bEnableDerivatives = GetNodeCheckAdd(trFuncTree, STR_FUNC_ENABLE_DERIVATIVES, false, "").nVal;
	///---Jasmine 07/11/07 value should be 1|0
	_strVal = bEnableDerivatives? "1" : "0";//"On" : "Off";
	//SetGeneralInfo(trFuncDetail, bEnableDerivatives, STR_FUNC_ANALYTICAL_DERIVATIVES, _strVal);
	//move here from NumFunctionOrganizer
	TreeNode trEnableDerivatives = GetGeneralInfo(trFuncDetail, bEnableDerivatives, STR_FUNC_ANALYTICAL_DERIVATIVES);	
	if(trEnableDerivatives.IsValid())
	{
		trEnableDerivatives.strVal = _strVal;
		trEnableDerivatives.SetAttribute(STR_ID_ATTRIB, IDS_OPTION_USERDEF_ANALYT_DERIV);
	}
	///---End
	///End ADD_DERIVATIVES_CHECKBOX
	
	//function formula
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_FUNCTION, false, "").strVal;
	GetFormula(trFuncDetail, true, STR_FUNC_SCRIPT).strVal 	 = _strVal;
	
	/// YuI 09/07/05 NLSF_CODE_BUILDER_COMMUNICATION_FIX
	GetFunctionOCHeader(trFuncDetail, true, STR_FUNC_SCRIPT).strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_OC_FUNC_HEADER, false, "").strVal;
	GetParaInitOCHeader(trFuncDetail, true, STR_FUNC_SCRIPT).strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_OC_PARA_INIT_HEADER, false, "").strVal;
	/// end NLSF_CODE_BUILDER_COMMUNICATION_FIX
	
	///------ Folger 11/28/09 QA81-14726-P2 80_HAS_MISSED_CONSTANTS_SECTION
	/////Jasmine 11/24/09 QA80-14726 80_HAS_MISSED_CONSTANTS_SECTION
	//TreeNode trGUIConstants = GetNodeCheckAdd(trFuncTree, STR_FUNC_CONSTANTS, false, "");
	//TreeNode trFDFConstants = GetNodeCheckAdd(trFuncDetail, STR_FUNC_CONSTANTS, true, "");
	//tree_key_value_pairs_str_to_branch(trFDFConstants, trGUIConstants.strVal);
	/////End 80_HAS_MISSED_CONSTANTS_SECTION
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_CONSTANTS, false, "").strVal;
	GetConstants(trFuncDetail, true, STR_FUNC_SCRIPT).strVal = _strVal;
	GetConstants(trFuncDetail, true).SetAttribute(STR_ID_ATTRIB, IDS_SECT_CONSTANTS);	///Jasmine 07/23/10 ORG-623-P2 NEWLY_CREATED_CONSTANTS_NODE_HAS_NO_ID_AND_FAIL_TO_WORK
	///------ End 80_HAS_MISSED_CONSTANTS_SECTION
	
//#ifdef SUPPORT_CONSTRAINTS	/// Max 6/6/07 TURN_ON_CONSTRAINTS
	//Constraints
	_strVal = GetNodeCheckAdd(trFuncTree, STR_FUNC_CONSTRAINTS, false, "").strVal;
	GetConstraints(trFuncDetail, true, STR_FUNC_SCRIPT).strVal = _strVal;
//#endif //SUPPORT_CONSTRAINTS	/// Max 6/6/07 TURN_ON_CONSTRAINTS
	//--- CPY 1/7/05 DERIVED_PARAMETERS_READ_SAVE_PROBLEM
	//GetDerivedParams(trFuncDetail).strVal=trFuncTree.DerivedParameters.strVal;
	TreeNode trGUIDerivedParams = GetDerivedParams(trFuncTree);
	TreeNode trFDFDerivedParams = GetDerivedParams(trFuncDetail, true);
	///Jasmine 07/10/07 SET_ID_TO_NEW_DERIVED_PARAMETERS_TREENODE
	if(trFDFDerivedParams)
		trFDFDerivedParams.SetAttribute(STR_ID_ATTRIB, IDS_SECT_DERIVED_PARAMETERS);
	///End SET_ID_TO_NEW_DERIVED_PARAMETERS_TREENODE
	tree_key_value_pairs_str_to_branch(trFDFDerivedParams, trGUIDerivedParams.strVal);
	//---
	
	///DG REMOVE_SHARE_CHECK_BOX
	/*
	if(1 == trFuncTree.UserInfo.nVal)
		trFuncDetail.SetAttribute(STR_CURRENT_SHARE_STATE_ATTRIB, 1);
	else
		trFuncDetail.RemoveAttribute(STR_CURRENT_SHARE_STATE_ATTRIB);
	*/
	///END REMOVE_SHARE_CHECK_BOX
	
	///Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
	//Controls
	bool bCheck = true;
	TreeNode trCheck = GetNodeCheckAdd(trFuncTree, STR_FUNC_ENABLE_INIT_SCRIPT, false);
	if(trCheck.IsValid())
		bCheck = trCheck.nVal;
	GetControls(trFuncDetail, true, STR_COMPILE_PARAM_SCRIPT).strVal = bCheck?"1":"0";//"On":"Off";	///Jasmine 06/05/07 QA80-9853 NEED_CHECK_STR_COMPILE_PARAM_SCRIPT_FOR_75_FDF
	GetControls(trFuncDetail, true, STR_FUNC_ENABLE_PARAMETERS_INIT).strVal = bCheck?"1":"0";//"On":"Off";//STR_FUNC_INIT_SCRIPT
//#ifdef SUPPORT_CONSTRAINTS	/// Max 6/6/07 TURN_ON_CONSTRAINTS
	bCheck = true;
	trCheck = GetNodeCheckAdd(trFuncTree, STR_FUNC_ENABLE_CONSTRAINTS, false);	
	if(trCheck.IsValid())
		bCheck = trCheck.nVal;
	GetControls(trFuncDetail, true, STR_FUNC_GENERAL_CONSTRAINTS).strVal = bCheck?"1":"0";//"On":"Off";
//#endif //SUPPORT_CONSTRAINTS	/// Max 6/6/07 TURN_ON_CONSTRAINTS
	///End ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
	///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	GetGeneralInfo(trFuncDetail, true, STR_FUNCTION_SOURCE).strVal = GetNodeCheckAdd(trFuncTree, STR_FUNCTION_DLL_SOURCE, false).strVal;
	///End ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
	
	///Jasmine 07/22/10 ORG-598-P3 NOT_RETURN_FOR_MINOR_ERROR
	//return true;
	return strErrMsg.IsEmpty();
	///End NOT_RETURN_FOR_MINOR_ERROR
}
int			NumFunctionOrganizerEx::ConvertCategoryDetailToGUITree(const TreeNode &trCategoryDetail, TreeNode &trCateTree, vector<int> &vnInvalidDetailIndex)
{
	int nIndex=0;
	string strName;
	tree_node_copy_attribute(trCategoryDetail, trCateTree, STR_LABEL_ATTRIB);
	foreach(TreeNode trFunction in trCateTree.Children)
	{
		nIndex++;
		if(!IsFunction(trFunction) || trFunction.GetNodeCount() > 1)
			continue;	//if detail has been loaded or is category node, ignore
		strName = GetLabel(trFunction);
		TreeNode trFuncDetail=trCategoryDetail.FindNodeByAttribute(STR_LABEL_ATTRIB, strName);
		if(trFuncDetail)
			ConstructFuncGUITree(trFuncDetail, trFunction);
		else
		{
			trFunction.Remove();
			vnInvalidDetailIndex.Add(nIndex);
		}
	}
	return nIndex;
}

void 		NumFunctionOrganizerEx::setupMultilineEditNode(TreeNode& trGUI, const TreeNode& trFDF, int nEnable, int nButtonEditID)// = 0
{
	string strParaInit;
	if(trFDF)
	{
		strParaInit = trFDF.strVal;
		//------ CPY 1/7/05 DERIVED_PARAMETERS_READ_SAVE_PROBLEM
		// following not really needed, XML str cannot have \r\n, so whatever in  strVal is fine
		/*
		if(strParaInit.GetLength() > 2)
		{
			strParaInit.TrimLeft();
			strParaInit.TrimRight();	
			strParaInit.Replace('\t',' ');
			strParaInit.Replace("\n","\r\n");
		}
		*/
	}
	trGUI.strVal = strParaInit;
	/// Iris/Hong 02/12/2007 v8.0560 ADD_EXPSHR_BUTTON_ON_MULTI_EDIT
	trGUI.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 0);
	///end ADD_EXPSHR_BUTTON_ON_MULTI_EDIT
	
	//----- CPY TD 5/3/07 QA70-9714 FO_CHANGED_TO_USE_FULL_WIDTH_FOR_MULTILINE_EDIT
	//trGUI.SetAttribute(STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE, MAX_ROW_HEIGTH_SETTING);
	//if(nButtonEditID > 0)
	//	trGUI.SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonEditID);
	//else
	//	trGUI.RemoveAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB);
	trGUI.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_WRAPPED);
	if(nButtonEditID > 0)
	{
		trGUI.SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonEditID);
		trGUI.SetAttribute(STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE, MAX_ROW_HEIGTH_SETTING);
	}
	else
	{
		trGUI.RemoveAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB);
		trGUI.SetAttribute(STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE, MAX_ROW_HEIGHT_NO_EDITOR);
	}
	//-----
	
	/// TD 4-2-07 QA80-9531 EDITORS_HAVE_NEW_READONLY_STATE 
	//trGUI.Enable = nEnable;
	trGUI.Enable = nEnable ? ENABLE : ENABLE_READONLY_SCROLL;
	/// end EDITORS_HAVE_NEW_READONLY_STATE 
}
void		NumFunctionOrganizerEx::recordAttribute(const TreeNode &trSrc, TreeNode &trDest)
{
	for(int ii=0; ii<m_vsCopyAttribute.GetSize(); ii++)
		tree_node_copy_attribute(trSrc, trDest, m_vsCopyAttribute[ii]);
}
///DG CLEAN_DUPLICATE_MORE
///Jasmine 11/24/06 MSG_FOR_REPEATED_VAR_NAME
void 		NumFunctionOrganizerEx::onVariableNameListChange(TreeNode &trVarList, TreeNode &tr, string *pStrError)//=NULL
{
	string strList=trVarList.strVal;
	correctVarNameList(strList, ',', pStrError);
	trVarList.strVal=strList;
}
//Check if has wrong Variable name, if then correct it
int			NumFunctionOrganizerEx::correctVarNameList(string &strList, char chDelimiter, string *pStrError)//=NULL
{
	string strErrMsg;
	int nParaVar1, nParaVar2;
	strList.Replace(';', chDelimiter);	//Danice 12/9/04 : recognize ';'
	vector<string> vsParaName;
	nParaVar1 = strList.GetTokens(vsParaName, chDelimiter);
	
	//Check if variable name is ok
	for(int ii=0; ii<nParaVar1; ii++)
	///Jasmine 07/23/07 MAKE_VALID_C_NAME_IS_STRICTER
		//is_str_valid_for_filename(vsParaName[ii], true);
	{
		string strTemp = vsParaName[ii];
		strTemp.MakeValidCName();
		vsParaName[ii] = strTemp;
	}
	///End MAKE_VALID_C_NAME_IS_STRICTER
	///Jasmine 07/23/07 NO_POPUP_MESSAGE_IF_NO_NEED 
	remove_repeat_item(vsParaName, false);
	nParaVar2 = vsParaName.GetSize();
	if(nParaVar1 != nParaVar2)
		strErrMsg += "Repeated variable name is removed.\n";
	remove_repeat_item(vsParaName);
	///End NO_POPUP_MESSAGE_IF_NO_NEED
	nParaVar2=strList.SetTokens(vsParaName, chDelimiter);
	if(pStrError)
		*pStrError = strErrMsg;
	return nParaVar2;
}
///End MSG_FOR_REPEATED_VAR_NAME
///end CLEAN_DUPLICATE_MORE
///Jasmine 06/02/08 BOOL_NAME_MISLEADING_IN_ConstructFuncGUITree
bool 		NumFunctionOrganizerEx::isFuncReadOnly(TreeNode trFunc)
{
	//Currently, Built-in and External DLL function should be read only.
	if( IsSysFunc(trFunc) )
		return true;
	
	if( isFuncExternalDLL(trFunc) )
		return true;
	
	return false;
}
///End BOOL_NAME_MISLEADING_IN_ConstructFuncGUITree
///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
bool 		NumFunctionOrganizerEx::isFuncExternalDLL(TreeNode trFunc)
{
	if(trFunc && trFunc.GeneralInformation.FunctionType)
	{
		string strFuncType = trFunc.GeneralInformation.FunctionType.strVal;
		return !strFuncType.Compare(STR_FUNCTION_TYPE_EXTERN_DLL);
	}
	return false;
}
///End ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX

int			NumFunctionOrganizerEx::addSubNodeByList(string strList, TreeNode &trRoot, char chDelimiter)
{
	vector<string> vsItems;
	//------ CPY 2/19/2007 FO_NEW_FUNC_PARAM_NAMES_LEADING_SPACE_FAILED
	//strList.GetTokens(vsItems, chDelimiter);
	okutil_get_tokens(strList, &vsItems, chDelimiter, NULL, ' ');
	//------
	trRoot.Reset(true);
	
	for(int ii=0; ii<vsItems.GetSize(); ii++)
		trRoot.AddNode(vsItems[ii]);
	
	return ii;
}

string 		NumFunctionOrganizerEx::GetFunctionName(TreeNode& trFunction, bool bPrefixIncluding)
{
	string strFunctionName;
	if(!trFunction || !trFunction.FunctionName)
		return strFunctionName;
	
	strFunctionName=trFunction.FunctionName.strVal;
	if( bPrefixIncluding )
	{
		int nFolder;
		GetFuncFileName(trFunction, true, &nFolder);
		strFunctionName = GetFunctionNameStr(strFunctionName, nFolder);		
	}
	
	return strFunctionName;		
}
void 		NumFunctionOrganizerEx::SetFunctionName(TreeNode& trFunction, string strFunctionName, const int *pnPath) //= NULL
{
	string strNameAlone = okutil_separate_composite_name(strFunctionName);
	if(NULL != pnPath)
		strFunctionName = GetFunctionNameStr(strNameAlone, *pnPath);
	TreeNode 	trNode=GetNodeCheckAdd(trFunction, STR_FUNC_NAME);
	trNode.strVal=strNameAlone;
	SetLabel(trFunction, strFunctionName); //addition
}
///DG 4/1/05 CLEAN_DUPLICATE_MORE
int			NumFunctionOrganizerEx::OnShowMenu(TreeNode &trRow, TreeNode &trFunction, int nx, int ny, HWND hWndParent, int nRow, bool bFODlg)
{
	//fit function don't support context menu for detail editing
	return -1;
}
///end CLEAN_DUPLICATE_MORE



//////////////////////////Implementation of  FitFunctionOrganizer class////////////////////////////////////

///Sophy 11/9/2009 INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI
//virtual
void 		FitFunctionOrganizer::ConstructFuncGUITree(const TreeNode& trFuncDetail, TreeNode &trFuncTree)
{
	if(!trFuncDetail)
		return;
	
	
	string strFuncName = NLFunctionList::GetFunctionName(trFuncDetail);
	string strFileName = NLFunctionList::GetFuncFileName(trFuncDetail, true);	///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE, show full path 

	TreeNode 	trNode;
	string 		strTemp;
	
	
	
	GETN_USE(trFuncTree);
	
	GETN_STR_L(STR_FUNC_NAME, strFuncName) GETN_ID(FUNC_TREE_FUNC_NAME_ID) GETN_CURRENT_SUBNODE.Enable = false;
	GETN_STR_L( STR_FUNC_FILE_NAME, strFileName) GETN_ID(FUNC_TREE_FILE_NAME_ID) GETN_CURRENT_SUBNODE.Enable = ENABLE_READONLY_SCROLL;
	
	//formula
	trNode = GetFormula(trFuncDetail, false, STR_FUNC_SCRIPT);
	strTemp = trNode.strVal;
	GETN_MULTILINE_TEXT_L( STR_FUNC_FUNCTION, strTemp)	GETN_ID(FUNC_TREE_FUNCTION_ID) GETN_CURRENT_SUBNODE.Enable = ENABLE_READONLY_SCROLL;

	//parameters names
	//trNode = GetFittingPara(trFuncDetail, false, STR_FUNC_NAMES);
	//strTemp = trNode ? trNode.strVal : "";
	//GETN_STR_L(STR_FUNC_PARAMETER_NAMES, strTemp) GETN_ID(FUNC_TREE_PARAMETER_NAMES_ID) GETN_CURRENT_SUBNODE.Enable = false;
	
	trNode = GetNodeCheckAdd(trFuncDetail, STR_FUNC_INDEPENDENT_VARS, false);
	if ( trNode )
	{
		vector<string> vsNodeNames;
		tree_get_node_names(trNode, vsNodeNames, true);
		int nVars = vsNodeNames.GetSize();
		GETN_BEGIN_BRANCH(IndpendentVars, STR_FUNC_INDEPENDENT_VARS) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) GETN_ID_BRANCH(FUNC_TREE_INDEPENDENT_VARS_ID)
			for ( int iVar = 0; iVar < nVars; iVar++ )
			{
				GETN_STR(Var, vsNodeNames[iVar], "");
			}
		GETN_END_BRANCH(IndpendentVars)

	}
	
	trNode = GetFittingPara(trFuncDetail, false, STR_FUNC_NAMES);
	strTemp = trNode.strVal;
	vector<string> vsParams;
	int nParams = strTemp.GetTokens(vsParams, ',');
	
	
	GETN_BEGIN_BRANCH(ParamSettings, STR_FUNC_FIT_PARAM) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) GETN_ID_BRANCH(IDST_SIMULATE_PARAS)
		for ( int iParam = 0; iParam < nParams; iParam++ )
		{
			GETN_STR(Param, vsParams[iParam], "");
		}
	GETN_END_BRANCH(ParamSettings)
}
///end INSERT_FITFUNCTION_IN_SCV_DLG_NEED_NEW_FITTING_FUNCTION_GUI


#endif //_NFO_EX_H_
